// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Mail Folder Request.
 */
public interface IBaseMailFolderRequest extends IHttpRequest {

    /**
     * Gets the MailFolder from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<MailFolder> callback);

    /**
     * Gets the MailFolder from the service
     * @return The MailFolder from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    MailFolder get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this MailFolder with a source
     * @param sourceMailFolder The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final MailFolder sourceMailFolder, final ICallback<MailFolder> callback);

    /**
     * Patches this MailFolder with a source
     * @param sourceMailFolder The source object with updates
     * @return The updated MailFolder
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    MailFolder patch(final MailFolder sourceMailFolder) throws ClientException;

    /**
     * Posts a MailFolder with a new object
     * @param newMailFolder The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final MailFolder newMailFolder, final ICallback<MailFolder> callback);

    /**
     * Posts a MailFolder with a new object
     * @param newMailFolder The new object to create
     * @return The created MailFolder
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    MailFolder post(final MailFolder newMailFolder) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseMailFolderRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseMailFolderRequest expand(final String value);

}
