// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base User Reminder View Collection Request Builder.
 */
public class BaseUserReminderViewCollectionRequestBuilder extends BaseRequestBuilder implements IBaseUserReminderViewCollectionRequestBuilder {

    public final String mStartDateTime;
    public final String mEndDateTime;

    /**
     * The request builder for this collection of User
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseUserReminderViewCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> options, final String startDateTime, final String endDateTime) {
        super(requestUrl, client, options);
        mStartDateTime = startDateTime;
        mEndDateTime = endDateTime;
    }

    public IUserReminderViewCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IUserReminderViewCollectionRequest buildRequest(final List<Option> options) {
        return new UserReminderViewCollectionRequest(getRequestUrl(), getClient(), options, mStartDateTime, mEndDateTime);
    }
}
