// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

import com.google.gson.JsonObject;
import com.google.gson.annotations.*;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Post.
 */
public class BasePost extends OutlookItem implements IJsonBackedObject {


	public BasePost(){
		oDataType = "microsoft.graph.post";
	}
	
    /**
     * The Body.
     */
    @SerializedName("body")
    public ItemBody body;

    /**
     * The Received Date Time.
     */
    @SerializedName("receivedDateTime")
    public java.util.Calendar receivedDateTime;

    /**
     * The Has Attachments.
     */
    @SerializedName("hasAttachments")
    public Boolean hasAttachments;

    /**
     * The From.
     */
    @SerializedName("from")
    public Recipient from;

    /**
     * The Sender.
     */
    @SerializedName("sender")
    public Recipient sender;

    /**
     * The Conversation Thread Id.
     */
    @SerializedName("conversationThreadId")
    public String conversationThreadId;

    /**
     * The New Participants.
     */
    @SerializedName("newParticipants")
    public List<Recipient> newParticipants;

    /**
     * The Conversation Id.
     */
    @SerializedName("conversationId")
    public String conversationId;

    /**
     * The In Reply To.
     */
    @SerializedName("inReplyTo")
    public Post inReplyTo;

    /**
     * The Attachments.
     */
    public transient AttachmentCollectionPage attachments;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;


        if (json.has("attachments")) {
            final BaseAttachmentCollectionResponse response = new BaseAttachmentCollectionResponse();
            if (json.has("attachments@odata.nextLink")) {
                response.nextLink = json.get("attachments@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("attachments").toString(), JsonObject[].class);
            final Attachment[] array = new Attachment[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Attachment.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            attachments = new AttachmentCollectionPage(response, null);
        }
    }
}
