// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Permission Collection Request.
 */
public class BasePermissionCollectionRequest extends BaseCollectionRequest<BasePermissionCollectionResponse, IPermissionCollectionPage> implements IBasePermissionCollectionRequest {

    /**
     * The request builder for this collection of Permission
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BasePermissionCollectionRequest(final String requestUrl, IBaseClient client, final List<Option> options) {
        super(requestUrl, client, options, BasePermissionCollectionResponse.class, IPermissionCollectionPage.class);
    }

    public void get(final ICallback<IPermissionCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IPermissionCollectionPage get() throws ClientException {
        final BasePermissionCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Permission newPermission, final ICallback<Permission> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new PermissionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest()
            .post(newPermission, callback);
    }

    public Permission post(final Permission newPermission) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new PermissionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest()
            .post(newPermission);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IPermissionCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("expand", value));
        return (PermissionCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IPermissionCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("select", value));
        return (PermissionCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IPermissionCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("top", value + ""));
        return (PermissionCollectionRequest)this;
    }

    public IPermissionCollectionPage buildFromResponse(final BasePermissionCollectionResponse response) {
        final IPermissionCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new PermissionCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final PermissionCollectionPage page = new PermissionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
