// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Message Create Reply Request.
 */
public class BaseMessageCreateReplyRequest extends BaseRequest implements IBaseMessageCreateReplyRequest {

    /**
     * The request for this MessageCreateReply
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseMessageCreateReplyRequest(final String requestUrl, final IBaseClient client, final List<Option> options) {
        super(requestUrl, client, options, Message.class);

    }

    /**
     * Creates the Message
     *
     * @param callback The callback to be called after success or failure.
     */
    public void post(final ICallback<Message> callback) {
        send(HttpMethod.POST, callback, null);
    }

    /**
     * Creates the Message
     *
     * @return The Message
     * @throws ClientException An exception occurs if there was an error while the request was sent.
     */
    public Message post() throws ClientException {
       return send(HttpMethod.POST, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IMessageCreateReplyRequest select(final String value) {
        getQueryOptions().add(new QueryOption("select", value));
        return (MessageCreateReplyRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IMessageCreateReplyRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("expand", value));
        return (MessageCreateReplyRequest)this;
    }
}
