// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Drive Shared With Me Collection Request.
 */
public class BaseDriveSharedWithMeCollectionRequest extends BaseCollectionRequest<BaseDriveSharedWithMeCollectionResponse, IDriveSharedWithMeCollectionPage> implements IBaseDriveSharedWithMeCollectionRequest {


    /**
     * The request for this DriveSharedWithMe
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseDriveSharedWithMeCollectionRequest(final String requestUrl, final IBaseClient client, final List<Option> options) {
        super(requestUrl, client, options, BaseDriveSharedWithMeCollectionResponse.class, IDriveSharedWithMeCollectionPage.class);
    }


    public void get(final ICallback<IDriveSharedWithMeCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IDriveSharedWithMeCollectionPage get() throws ClientException {
        final BaseDriveSharedWithMeCollectionResponse response = send();
        return buildFromResponse(response);
    }


    public IDriveSharedWithMeCollectionPage buildFromResponse(final BaseDriveSharedWithMeCollectionResponse response) {
        final IDriveSharedWithMeCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new DriveSharedWithMeCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final IDriveSharedWithMeCollectionPage page = new DriveSharedWithMeCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IDriveSharedWithMeCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("select", value));
        return (IDriveSharedWithMeCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IDriveSharedWithMeCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("top", value+""));
        return (IDriveSharedWithMeCollectionRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IDriveSharedWithMeCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("expand", value));
        return (IDriveSharedWithMeCollectionRequest)this;
    }
}
