// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Drive Item Create Link Request Builder.
 */
public class BaseDriveItemCreateLinkRequestBuilder extends BaseRequestBuilder {

    public final String mType;
    public final String mScope;

    /**
     * The request builder for this DriveItemCreateLink
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseDriveItemCreateLinkRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> options, final String type, final String scope) {
        super(requestUrl, client, options);
        mType = type;
        mScope = scope;
    }

    /**
     * Creates the IDriveItemCreateLinkRequest
     *
     * @return The IDriveItemCreateLinkRequest instance
     */
    public IDriveItemCreateLinkRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IDriveItemCreateLinkRequest with specific options instead of the existing options
     *
     * @param options the options for the request
     * @return The IDriveItemCreateLinkRequest instance
     */
    public IDriveItemCreateLinkRequest buildRequest(final List<Option> options) {
        return new DriveItemCreateLinkRequest(getRequestUrl(), getClient(), options, mType, mScope);
    }
}
