// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Directory Role Template Collection Request Builder.
 */
public class BaseDirectoryRoleTemplateCollectionRequestBuilder extends BaseRequestBuilder implements IBaseDirectoryRoleTemplateCollectionRequestBuilder {

    /**
     * The request builder for this collection of DirectoryRoleTemplate
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseDirectoryRoleTemplateCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> options) {
        super(requestUrl, client, options);
    }

    public IDirectoryRoleTemplateCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IDirectoryRoleTemplateCollectionRequest buildRequest(final List<Option> options) {
        return new DirectoryRoleTemplateCollectionRequest(getRequestUrl(), getClient(), options);
    }

    public IDirectoryRoleTemplateRequestBuilder byId(final String id) {
        return new DirectoryRoleTemplateRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }
}
