/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.logger;

import android.util.Log;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.logger.LoggerLevel;

public class DefaultLogger
implements ILogger {
    private LoggerLevel mLevel = LoggerLevel.Error;

    @Override
    public void setLoggingLevel(LoggerLevel level) {
        Log.i((String)this.getTag(), (String)("Setting logging level to " + (Object)((Object)level)));
        this.mLevel = level;
    }

    @Override
    public LoggerLevel getLoggingLevel() {
        return this.mLevel;
    }

    private String getTag() {
        try {
            StringBuilder sb = new StringBuilder();
            int callerStackDepth = 4;
            String className = Thread.currentThread().getStackTrace()[4].getClassName();
            sb.append(className.substring(className.lastIndexOf(".") + 1));
            sb.append("[");
            sb.append(Thread.currentThread().getStackTrace()[4].getMethodName());
            sb.append("] - ");
            sb.append(Thread.currentThread().getStackTrace()[4].getLineNumber());
            return sb.toString();
        }
        catch (Exception ex) {
            Log.e((String)"DefaultLogger", (String)ex.getMessage());
            return null;
        }
    }

    @Override
    public void logDebug(String message) {
        switch (this.mLevel) {
            case Debug: {
                Log.d((String)this.getTag(), (String)message);
            }
        }
    }

    @Override
    public void logError(String message, Throwable throwable) {
        switch (this.mLevel) {
            default: 
        }
        Log.e((String)this.getTag(), (String)message, (Throwable)throwable);
    }
}

