/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.DriveItemDeltaCollectionPage;
import com.microsoft.graph.extensions.DriveItemDeltaRequestBuilder;
import com.microsoft.graph.extensions.IDriveItemDeltaCollectionPage;
import com.microsoft.graph.extensions.IDriveItemDeltaCollectionRequest;
import com.microsoft.graph.generated.BaseDriveItemDeltaCollectionResponse;
import com.microsoft.graph.generated.IBaseDriveItemDeltaCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseDriveItemDeltaCollectionRequest
extends BaseCollectionRequest<BaseDriveItemDeltaCollectionResponse, IDriveItemDeltaCollectionPage>
implements IBaseDriveItemDeltaCollectionRequest {
    public BaseDriveItemDeltaCollectionRequest(String requestUrl, IBaseClient client, List<Option> options) {
        super(requestUrl, client, options, BaseDriveItemDeltaCollectionResponse.class, IDriveItemDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveItemDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDriveItemDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveItemDeltaCollectionPage get() throws ClientException {
        BaseDriveItemDeltaCollectionResponse response = (BaseDriveItemDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IDriveItemDeltaCollectionPage buildFromResponse(BaseDriveItemDeltaCollectionResponse response) {
        DriveItemDeltaRequestBuilder builder = response.nextLink != null ? new DriveItemDeltaRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DriveItemDeltaCollectionPage page = new DriveItemDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDriveItemDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (IDriveItemDeltaCollectionRequest)((Object)this);
    }

    @Override
    public IDriveItemDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (IDriveItemDeltaCollectionRequest)((Object)this);
    }

    @Override
    public IDriveItemDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (IDriveItemDeltaCollectionRequest)((Object)this);
    }
}

