// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Mail Folder Collection Request.
 */
public class BaseMailFolderCollectionRequest extends BaseCollectionRequest<BaseMailFolderCollectionResponse, IMailFolderCollectionPage> implements IBaseMailFolderCollectionRequest {

    /**
     * The request builder for this collection of MailFolder
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseMailFolderCollectionRequest(final String requestUrl, IBaseClient client, final List<Option> options) {
        super(requestUrl, client, options, BaseMailFolderCollectionResponse.class, IMailFolderCollectionPage.class);
    }

    public void get(final ICallback<IMailFolderCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IMailFolderCollectionPage get() throws ClientException {
        final BaseMailFolderCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final MailFolder newMailFolder, final ICallback<MailFolder> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new MailFolderRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest()
            .post(newMailFolder, callback);
    }

    public MailFolder post(final MailFolder newMailFolder) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new MailFolderRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest()
            .post(newMailFolder);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IMailFolderCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("expand", value));
        return (MailFolderCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IMailFolderCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("select", value));
        return (MailFolderCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IMailFolderCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("top", value + ""));
        return (MailFolderCollectionRequest)this;
    }

    public IMailFolderCollectionPage buildFromResponse(final BaseMailFolderCollectionResponse response) {
        final IMailFolderCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new MailFolderCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final MailFolderCollectionPage page = new MailFolderCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
