// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Directory Object Check Member Groups Request Builder.
 */
public class BaseDirectoryObjectCheckMemberGroupsRequestBuilder extends BaseRequestBuilder {

    public final List<String> mGroupIds;

    /**
     * The request builder for this DirectoryObjectCheckMemberGroups
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseDirectoryObjectCheckMemberGroupsRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> options, final List<String> groupIds) {
        super(requestUrl, client, options);
        mGroupIds = groupIds;
    }

    /**
     * Creates the IDirectoryObjectCheckMemberGroupsRequest
     *
     * @return The IDirectoryObjectCheckMemberGroupsRequest instance
     */
    public IDirectoryObjectCheckMemberGroupsRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IDirectoryObjectCheckMemberGroupsRequest with specific options instead of the existing options
     *
     * @param options the options for the request
     * @return The IDirectoryObjectCheckMemberGroupsRequest instance
     */
    public IDirectoryObjectCheckMemberGroupsRequest buildRequest(final List<Option> options) {
        return new DirectoryObjectCheckMemberGroupsRequest(getRequestUrl(), getClient(), options, mGroupIds);
    }
}
