// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Device Request.
 */
public class BaseDeviceRequest extends DirectoryObjectRequest implements IBaseDeviceRequest {

    /**
     * The request for the Device
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseDeviceRequest(final String requestUrl,
            final IBaseClient client,
            final List<Option> options,
            final Class responseClass) {
        super(requestUrl, client, options, responseClass);
    }

    /**
     * Gets the Device from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<Device> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Device from the service
     * @return The Device from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Device get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this Device with a source
     * @param sourceDevice The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final Device sourceDevice, final ICallback<Device> callback) {
        send(HttpMethod.PATCH, callback, sourceDevice);
    }

    /**
     * Patches this Device with a source
     * @param sourceDevice The source object with updates
     * @return The updated Device
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Device patch(final Device sourceDevice) throws ClientException {
        return send(HttpMethod.PATCH, sourceDevice);
    }

    /**
     * Creates a Device with a new object
     * @param newDevice The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final Device newDevice, final ICallback<Device> callback) {
        send(HttpMethod.POST, callback, newDevice);
    }

    /**
     * Creates a Device with a new object
     * @param newDevice The new object to create
     * @return The created Device
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Device post(final Device newDevice) throws ClientException {
        return send(HttpMethod.POST, newDevice);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IDeviceRequest select(final String value) {
         getQueryOptions().add(new QueryOption("select", value));
         return (DeviceRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IDeviceRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("expand", value));
         return (DeviceRequest)this;
     }
}
