// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Calendar Collection Request.
 */
public class BaseCalendarCollectionRequest extends BaseCollectionRequest<BaseCalendarCollectionResponse, ICalendarCollectionPage> implements IBaseCalendarCollectionRequest {

    /**
     * The request builder for this collection of Calendar
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseCalendarCollectionRequest(final String requestUrl, IBaseClient client, final List<Option> options) {
        super(requestUrl, client, options, BaseCalendarCollectionResponse.class, ICalendarCollectionPage.class);
    }

    public void get(final ICallback<ICalendarCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public ICalendarCollectionPage get() throws ClientException {
        final BaseCalendarCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Calendar newCalendar, final ICallback<Calendar> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new CalendarRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest()
            .post(newCalendar, callback);
    }

    public Calendar post(final Calendar newCalendar) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new CalendarRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest()
            .post(newCalendar);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public ICalendarCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("expand", value));
        return (CalendarCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public ICalendarCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("select", value));
        return (CalendarCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public ICalendarCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("top", value + ""));
        return (CalendarCollectionRequest)this;
    }

    public ICalendarCollectionPage buildFromResponse(final BaseCalendarCollectionResponse response) {
        final ICalendarCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new CalendarCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final CalendarCollectionPage page = new CalendarCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
