/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.Drive;
import com.microsoft.graph.extensions.DriveCollectionPage;
import com.microsoft.graph.extensions.DriveCollectionRequest;
import com.microsoft.graph.extensions.DriveCollectionRequestBuilder;
import com.microsoft.graph.extensions.DriveRequestBuilder;
import com.microsoft.graph.extensions.IDriveCollectionPage;
import com.microsoft.graph.extensions.IDriveCollectionRequest;
import com.microsoft.graph.generated.BaseDriveCollectionResponse;
import com.microsoft.graph.generated.IBaseDriveCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseDriveCollectionRequest
extends BaseCollectionRequest<BaseDriveCollectionResponse, IDriveCollectionPage>
implements IBaseDriveCollectionRequest {
    public BaseDriveCollectionRequest(String requestUrl, IBaseClient client, List<Option> options) {
        super(requestUrl, client, options, BaseDriveCollectionResponse.class, IDriveCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDriveCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveCollectionPage get() throws ClientException {
        BaseDriveCollectionResponse response = (BaseDriveCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Drive newDrive, ICallback<Drive> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DriveRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newDrive, callback);
    }

    @Override
    public Drive post(Drive newDrive) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DriveRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newDrive);
    }

    @Override
    public IDriveCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (DriveCollectionRequest)this;
    }

    @Override
    public IDriveCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (DriveCollectionRequest)this;
    }

    @Override
    public IDriveCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (DriveCollectionRequest)this;
    }

    public IDriveCollectionPage buildFromResponse(BaseDriveCollectionResponse response) {
        DriveCollectionRequestBuilder builder = response.nextLink != null ? new DriveCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DriveCollectionPage page = new DriveCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

