/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.authentication;

import android.app.Activity;
import android.app.Application;
import com.microsoft.graph.authentication.IAuthenticationAdapter;
import com.microsoft.graph.authentication.MicrosoftOAuth2Endpoint;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.SimpleWaiter;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.GraphErrorCodes;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.logger.DefaultLogger;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.services.msa.LiveAuthClient;
import com.microsoft.services.msa.LiveAuthException;
import com.microsoft.services.msa.LiveAuthListener;
import com.microsoft.services.msa.LiveConnectSession;
import com.microsoft.services.msa.LiveStatus;
import com.microsoft.services.msa.OAuthConfig;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public abstract class MSAAuthAndroidAdapter
implements IAuthenticationAdapter {
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    public static final String OAUTH_BEARER_PREFIX = "bearer ";
    private ILogger mLogger = new DefaultLogger();
    private final LiveAuthClient mLiveAuthClient;

    public abstract String getClientId();

    public abstract String[] getScopes();

    public void setLogger(ILogger logger) {
        this.mLogger = logger;
    }

    public MSAAuthAndroidAdapter(Application application) {
        application.getBaseContext();
        this.mLiveAuthClient = new LiveAuthClient(application.getApplicationContext(), this.getClientId(), Arrays.asList(this.getScopes()), (OAuthConfig)MicrosoftOAuth2Endpoint.getInstance());
    }

    public void authenticateRequest(IHttpRequest request) {
        this.mLogger.logDebug("Authenticating request, " + request.getRequestUrl());
        for (HeaderOption option : request.getHeaders()) {
            if (!option.getName().equals(AUTHORIZATION_HEADER_NAME)) continue;
            this.mLogger.logDebug("Found an existing authorization header!");
            return;
        }
        if (this.hasValidSession()) {
            this.mLogger.logDebug("Found account information");
            if (this.mLiveAuthClient.getSession().isExpired()) {
                this.mLogger.logDebug("Account access token is expired, refreshing");
                this.loginSilentBlocking();
            }
        } else {
            String message = "Unable to authenticate request, No active account found";
            ClientException exception = new ClientException("Unable to authenticate request, No active account found", null, GraphErrorCodes.AuthenticationFailure);
            this.mLogger.logError("Unable to authenticate request, No active account found", (Throwable)exception);
            throw exception;
        }
        String accessToken = this.mLiveAuthClient.getSession().getAccessToken();
        request.addHeader(AUTHORIZATION_HEADER_NAME, OAUTH_BEARER_PREFIX + accessToken);
    }

    @Override
    public void logout(final ICallback<Void> callback) {
        this.mLogger.logDebug("Logout started");
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
        this.mLiveAuthClient.logout(new LiveAuthListener(){

            public void onAuthComplete(LiveStatus status, LiveConnectSession session, Object userState) {
                MSAAuthAndroidAdapter.this.mLogger.logDebug("Logout complete");
                callback.success(null);
            }

            public void onAuthError(LiveAuthException exception, Object userState) {
                ClientException clientException = new ClientException("Logout failure", (Throwable)exception, GraphErrorCodes.AuthenticationFailure);
                MSAAuthAndroidAdapter.this.mLogger.logError(clientException.getMessage(), (Throwable)clientException);
                callback.failure(clientException);
            }
        });
    }

    @Override
    public void login(final Activity activity, final ICallback<Void> callback) {
        this.mLogger.logDebug("Login started");
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
        if (this.hasValidSession()) {
            this.mLogger.logDebug("Already logged in");
            callback.success(null);
            return;
        }
        final LiveAuthListener listener = new LiveAuthListener(){

            public void onAuthComplete(LiveStatus status, LiveConnectSession session, Object userState) {
                MSAAuthAndroidAdapter.this.mLogger.logDebug(String.format("LiveStatus: %s, LiveConnectSession good?: %s, UserState %s", status, session != null, userState));
                if (status == LiveStatus.NOT_CONNECTED) {
                    MSAAuthAndroidAdapter.this.mLogger.logDebug("Received invalid login failure from silent authentication, ignoring.");
                    return;
                }
                if (status == LiveStatus.CONNECTED) {
                    MSAAuthAndroidAdapter.this.mLogger.logDebug("Login completed");
                    callback.success(null);
                    return;
                }
                ClientException clientException = new ClientException("Unable to login successfully", null, GraphErrorCodes.AuthenticationFailure);
                MSAAuthAndroidAdapter.this.mLogger.logError(clientException.getMessage(), (Throwable)clientException);
                callback.failure(clientException);
            }

            public void onAuthError(LiveAuthException exception, Object userState) {
                ClientException clientException = new ClientException("Login failure", (Throwable)exception, GraphErrorCodes.AuthenticationFailure);
                MSAAuthAndroidAdapter.this.mLogger.logError(clientException.getMessage(), (Throwable)clientException);
                callback.failure(clientException);
            }
        };
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MSAAuthAndroidAdapter.this.mLiveAuthClient.login(activity, listener);
            }
        });
    }

    private void loginSilent(final ICallback<Void> callback) {
        this.mLogger.logDebug("Login silent started");
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
        LiveAuthListener listener = new LiveAuthListener(){

            public void onAuthComplete(LiveStatus status, LiveConnectSession session, Object userState) {
                MSAAuthAndroidAdapter.this.mLogger.logDebug(String.format("LiveStatus: %s, LiveConnectSession good?: %s, UserState %s", status, session != null, userState));
                if (status == LiveStatus.CONNECTED) {
                    MSAAuthAndroidAdapter.this.mLogger.logDebug("Login completed");
                    callback.success(null);
                    return;
                }
                ClientException clientException = new ClientException("Unable to login silently", null, GraphErrorCodes.AuthenticationFailure);
                MSAAuthAndroidAdapter.this.mLogger.logError(clientException.getMessage(), (Throwable)clientException);
                callback.failure(clientException);
            }

            public void onAuthError(LiveAuthException exception, Object userState) {
                ClientException clientException = new ClientException("Unable to login silently", null, GraphErrorCodes.AuthenticationFailure);
                MSAAuthAndroidAdapter.this.mLogger.logError(clientException.getMessage(), (Throwable)clientException);
                callback.failure(clientException);
            }
        };
        this.mLiveAuthClient.loginSilent(listener);
    }

    private Void loginSilentBlocking() throws ClientException {
        final SimpleWaiter waiter = new SimpleWaiter();
        final AtomicReference returnValue = new AtomicReference();
        final AtomicReference exceptionValue = new AtomicReference();
        this.loginSilent(new ICallback<Void>(){

            public void success(Void aVoid) {
                returnValue.set(aVoid);
                waiter.signal();
            }

            public void failure(ClientException ex) {
                exceptionValue.set(ex);
                waiter.signal();
            }
        });
        waiter.waitForSignal();
        if (exceptionValue.get() != null) {
            throw (ClientException)exceptionValue.get();
        }
        return (Void)returnValue.get();
    }

    private boolean hasValidSession() {
        return this.mLiveAuthClient.getSession() != null && this.mLiveAuthClient.getSession().getAccessToken() != null;
    }
}

