/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.users.item.joinedteams.item.sendactivitynotification;

import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.KeyValuePair;
import com.microsoft.graph.models.TeamworkActivityTopic;
import com.microsoft.graph.models.TeamworkNotificationRecipient;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SendActivityNotificationPostRequestBody
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SendActivityNotificationPostRequestBody() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SendActivityNotificationPostRequestBody createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SendActivityNotificationPostRequestBody();
    }

    @Nullable
    public String getActivityType() {
        return (String)this.backingStore.get("activityType");
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Long getChainId() {
        return (Long)this.backingStore.get("chainId");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("activityType", n -> this.setActivityType(n.getStringValue()));
        deserializerMap.put("chainId", n -> this.setChainId(n.getLongValue()));
        deserializerMap.put("previewText", n -> this.setPreviewText((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("recipient", n -> this.setRecipient((TeamworkNotificationRecipient)n.getObjectValue(TeamworkNotificationRecipient::createFromDiscriminatorValue)));
        deserializerMap.put("teamsAppId", n -> this.setTeamsAppId(n.getStringValue()));
        deserializerMap.put("templateParameters", n -> this.setTemplateParameters(n.getCollectionOfObjectValues(KeyValuePair::createFromDiscriminatorValue)));
        deserializerMap.put("topic", n -> this.setTopic((TeamworkActivityTopic)n.getObjectValue(TeamworkActivityTopic::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public ItemBody getPreviewText() {
        return (ItemBody)this.backingStore.get("previewText");
    }

    @Nullable
    public TeamworkNotificationRecipient getRecipient() {
        return (TeamworkNotificationRecipient)this.backingStore.get("recipient");
    }

    @Nullable
    public String getTeamsAppId() {
        return (String)this.backingStore.get("teamsAppId");
    }

    @Nullable
    public List<KeyValuePair> getTemplateParameters() {
        return (List)this.backingStore.get("templateParameters");
    }

    @Nullable
    public TeamworkActivityTopic getTopic() {
        return (TeamworkActivityTopic)this.backingStore.get("topic");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("activityType", this.getActivityType());
        writer.writeLongValue("chainId", this.getChainId());
        writer.writeObjectValue("previewText", (Parsable)this.getPreviewText(), new Parsable[0]);
        writer.writeObjectValue("recipient", (Parsable)this.getRecipient(), new Parsable[0]);
        writer.writeStringValue("teamsAppId", this.getTeamsAppId());
        writer.writeCollectionOfObjectValues("templateParameters", this.getTemplateParameters());
        writer.writeObjectValue("topic", (Parsable)this.getTopic(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setActivityType(@Nullable String value) {
        this.backingStore.set("activityType", (Object)value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setChainId(@Nullable Long value) {
        this.backingStore.set("chainId", (Object)value);
    }

    public void setPreviewText(@Nullable ItemBody value) {
        this.backingStore.set("previewText", (Object)value);
    }

    public void setRecipient(@Nullable TeamworkNotificationRecipient value) {
        this.backingStore.set("recipient", (Object)value);
    }

    public void setTeamsAppId(@Nullable String value) {
        this.backingStore.set("teamsAppId", (Object)value);
    }

    public void setTemplateParameters(@Nullable List<KeyValuePair> value) {
        this.backingStore.set("templateParameters", value);
    }

    public void setTopic(@Nullable TeamworkActivityTopic value) {
        this.backingStore.set("topic", (Object)value);
    }
}

