/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.ContainerImageEvidence;
import com.microsoft.graph.models.security.KubernetesPodEvidence;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ContainerEvidence
extends AlertEvidence
implements Parsable {
    public ContainerEvidence() {
        this.setOdataType("#microsoft.graph.security.containerEvidence");
    }

    @Nonnull
    public static ContainerEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ContainerEvidence();
    }

    @Nullable
    public List<String> getArgs() {
        return (List)this.backingStore.get("args");
    }

    @Nullable
    public List<String> getCommand() {
        return (List)this.backingStore.get("command");
    }

    @Nullable
    public String getContainerId() {
        return (String)this.backingStore.get("containerId");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("args", n -> this.setArgs(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("command", n -> this.setCommand(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("containerId", n -> this.setContainerId(n.getStringValue()));
        deserializerMap.put("image", n -> this.setImage((ContainerImageEvidence)n.getObjectValue(ContainerImageEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("isPrivileged", n -> this.setIsPrivileged(n.getBooleanValue()));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("pod", n -> this.setPod((KubernetesPodEvidence)n.getObjectValue(KubernetesPodEvidence::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public ContainerImageEvidence getImage() {
        return (ContainerImageEvidence)this.backingStore.get("image");
    }

    @Nullable
    public Boolean getIsPrivileged() {
        return (Boolean)this.backingStore.get("isPrivileged");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public KubernetesPodEvidence getPod() {
        return (KubernetesPodEvidence)this.backingStore.get("pod");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfPrimitiveValues("args", this.getArgs());
        writer.writeCollectionOfPrimitiveValues("command", this.getCommand());
        writer.writeStringValue("containerId", this.getContainerId());
        writer.writeObjectValue("image", (Parsable)this.getImage(), new Parsable[0]);
        writer.writeBooleanValue("isPrivileged", this.getIsPrivileged());
        writer.writeStringValue("name", this.getName());
        writer.writeObjectValue("pod", (Parsable)this.getPod(), new Parsable[0]);
    }

    public void setArgs(@Nullable List<String> value) {
        this.backingStore.set("args", value);
    }

    public void setCommand(@Nullable List<String> value) {
        this.backingStore.set("command", value);
    }

    public void setContainerId(@Nullable String value) {
        this.backingStore.set("containerId", (Object)value);
    }

    public void setImage(@Nullable ContainerImageEvidence value) {
        this.backingStore.set("image", (Object)value);
    }

    public void setIsPrivileged(@Nullable Boolean value) {
        this.backingStore.set("isPrivileged", (Object)value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setPod(@Nullable KubernetesPodEvidence value) {
        this.backingStore.set("pod", (Object)value);
    }
}

