/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.EducationOutcome;
import com.microsoft.graph.models.EducationSubmissionRecipient;
import com.microsoft.graph.models.EducationSubmissionResource;
import com.microsoft.graph.models.EducationSubmissionStatus;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EducationSubmission
extends Entity
implements Parsable {
    @Nonnull
    public static EducationSubmission createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new EducationSubmission();
    }

    @Nullable
    public IdentitySet getExcusedBy() {
        return (IdentitySet)this.backingStore.get("excusedBy");
    }

    @Nullable
    public OffsetDateTime getExcusedDateTime() {
        return (OffsetDateTime)this.backingStore.get("excusedDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("excusedBy", n -> this.setExcusedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("excusedDateTime", n -> this.setExcusedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("outcomes", n -> this.setOutcomes(n.getCollectionOfObjectValues(EducationOutcome::createFromDiscriminatorValue)));
        deserializerMap.put("reassignedBy", n -> this.setReassignedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("reassignedDateTime", n -> this.setReassignedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("recipient", n -> this.setRecipient((EducationSubmissionRecipient)n.getObjectValue(EducationSubmissionRecipient::createFromDiscriminatorValue)));
        deserializerMap.put("resources", n -> this.setResources(n.getCollectionOfObjectValues(EducationSubmissionResource::createFromDiscriminatorValue)));
        deserializerMap.put("resourcesFolderUrl", n -> this.setResourcesFolderUrl(n.getStringValue()));
        deserializerMap.put("returnedBy", n -> this.setReturnedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("returnedDateTime", n -> this.setReturnedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("status", n -> this.setStatus((EducationSubmissionStatus)n.getEnumValue(EducationSubmissionStatus::forValue)));
        deserializerMap.put("submittedBy", n -> this.setSubmittedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("submittedDateTime", n -> this.setSubmittedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("submittedResources", n -> this.setSubmittedResources(n.getCollectionOfObjectValues(EducationSubmissionResource::createFromDiscriminatorValue)));
        deserializerMap.put("unsubmittedBy", n -> this.setUnsubmittedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("unsubmittedDateTime", n -> this.setUnsubmittedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("webUrl", n -> this.setWebUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public List<EducationOutcome> getOutcomes() {
        return (List)this.backingStore.get("outcomes");
    }

    @Nullable
    public IdentitySet getReassignedBy() {
        return (IdentitySet)this.backingStore.get("reassignedBy");
    }

    @Nullable
    public OffsetDateTime getReassignedDateTime() {
        return (OffsetDateTime)this.backingStore.get("reassignedDateTime");
    }

    @Nullable
    public EducationSubmissionRecipient getRecipient() {
        return (EducationSubmissionRecipient)this.backingStore.get("recipient");
    }

    @Nullable
    public List<EducationSubmissionResource> getResources() {
        return (List)this.backingStore.get("resources");
    }

    @Nullable
    public String getResourcesFolderUrl() {
        return (String)this.backingStore.get("resourcesFolderUrl");
    }

    @Nullable
    public IdentitySet getReturnedBy() {
        return (IdentitySet)this.backingStore.get("returnedBy");
    }

    @Nullable
    public OffsetDateTime getReturnedDateTime() {
        return (OffsetDateTime)this.backingStore.get("returnedDateTime");
    }

    @Nullable
    public EducationSubmissionStatus getStatus() {
        return (EducationSubmissionStatus)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public IdentitySet getSubmittedBy() {
        return (IdentitySet)this.backingStore.get("submittedBy");
    }

    @Nullable
    public OffsetDateTime getSubmittedDateTime() {
        return (OffsetDateTime)this.backingStore.get("submittedDateTime");
    }

    @Nullable
    public List<EducationSubmissionResource> getSubmittedResources() {
        return (List)this.backingStore.get("submittedResources");
    }

    @Nullable
    public IdentitySet getUnsubmittedBy() {
        return (IdentitySet)this.backingStore.get("unsubmittedBy");
    }

    @Nullable
    public OffsetDateTime getUnsubmittedDateTime() {
        return (OffsetDateTime)this.backingStore.get("unsubmittedDateTime");
    }

    @Nullable
    public String getWebUrl() {
        return (String)this.backingStore.get("webUrl");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("outcomes", this.getOutcomes());
        writer.writeObjectValue("recipient", (Parsable)this.getRecipient(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("resources", this.getResources());
        writer.writeCollectionOfObjectValues("submittedResources", this.getSubmittedResources());
    }

    public void setExcusedBy(@Nullable IdentitySet value) {
        this.backingStore.set("excusedBy", (Object)value);
    }

    public void setExcusedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("excusedDateTime", (Object)value);
    }

    public void setOutcomes(@Nullable List<EducationOutcome> value) {
        this.backingStore.set("outcomes", value);
    }

    public void setReassignedBy(@Nullable IdentitySet value) {
        this.backingStore.set("reassignedBy", (Object)value);
    }

    public void setReassignedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("reassignedDateTime", (Object)value);
    }

    public void setRecipient(@Nullable EducationSubmissionRecipient value) {
        this.backingStore.set("recipient", (Object)value);
    }

    public void setResources(@Nullable List<EducationSubmissionResource> value) {
        this.backingStore.set("resources", value);
    }

    public void setResourcesFolderUrl(@Nullable String value) {
        this.backingStore.set("resourcesFolderUrl", (Object)value);
    }

    public void setReturnedBy(@Nullable IdentitySet value) {
        this.backingStore.set("returnedBy", (Object)value);
    }

    public void setReturnedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("returnedDateTime", (Object)value);
    }

    public void setStatus(@Nullable EducationSubmissionStatus value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setSubmittedBy(@Nullable IdentitySet value) {
        this.backingStore.set("submittedBy", (Object)value);
    }

    public void setSubmittedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("submittedDateTime", (Object)value);
    }

    public void setSubmittedResources(@Nullable List<EducationSubmissionResource> value) {
        this.backingStore.set("submittedResources", value);
    }

    public void setUnsubmittedBy(@Nullable IdentitySet value) {
        this.backingStore.set("unsubmittedBy", (Object)value);
    }

    public void setUnsubmittedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("unsubmittedDateTime", (Object)value);
    }

    public void setWebUrl(@Nullable String value) {
        this.backingStore.set("webUrl", (Object)value);
    }
}

