/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DriveItemSource;
import com.microsoft.graph.models.FileSystemInfo;
import com.microsoft.graph.models.MediaSource;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DriveItemUploadableProperties
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public DriveItemUploadableProperties() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static DriveItemUploadableProperties createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DriveItemUploadableProperties();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public DriveItemSource getDriveItemSource() {
        return (DriveItemSource)this.backingStore.get("driveItemSource");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("driveItemSource", n -> this.setDriveItemSource((DriveItemSource)n.getObjectValue(DriveItemSource::createFromDiscriminatorValue)));
        deserializerMap.put("fileSize", n -> this.setFileSize(n.getLongValue()));
        deserializerMap.put("fileSystemInfo", n -> this.setFileSystemInfo((FileSystemInfo)n.getObjectValue(FileSystemInfo::createFromDiscriminatorValue)));
        deserializerMap.put("mediaSource", n -> this.setMediaSource((MediaSource)n.getObjectValue(MediaSource::createFromDiscriminatorValue)));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Long getFileSize() {
        return (Long)this.backingStore.get("fileSize");
    }

    @Nullable
    public FileSystemInfo getFileSystemInfo() {
        return (FileSystemInfo)this.backingStore.get("fileSystemInfo");
    }

    @Nullable
    public MediaSource getMediaSource() {
        return (MediaSource)this.backingStore.get("mediaSource");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("description", this.getDescription());
        writer.writeObjectValue("driveItemSource", (Parsable)this.getDriveItemSource(), new Parsable[0]);
        writer.writeLongValue("fileSize", this.getFileSize());
        writer.writeObjectValue("fileSystemInfo", (Parsable)this.getFileSystemInfo(), new Parsable[0]);
        writer.writeObjectValue("mediaSource", (Parsable)this.getMediaSource(), new Parsable[0]);
        writer.writeStringValue("name", this.getName());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDriveItemSource(@Nullable DriveItemSource value) {
        this.backingStore.set("driveItemSource", (Object)value);
    }

    public void setFileSize(@Nullable Long value) {
        this.backingStore.set("fileSize", (Object)value);
    }

    public void setFileSystemInfo(@Nullable FileSystemInfo value) {
        this.backingStore.set("fileSystemInfo", (Object)value);
    }

    public void setMediaSource(@Nullable MediaSource value) {
        this.backingStore.set("mediaSource", (Object)value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

