/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.UnifiedApprovalStage;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ApprovalSettings
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ApprovalSettings() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ApprovalSettings createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ApprovalSettings();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public String getApprovalMode() {
        return (String)this.backingStore.get("approvalMode");
    }

    @Nullable
    public List<UnifiedApprovalStage> getApprovalStages() {
        return (List)this.backingStore.get("approvalStages");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("approvalMode", n -> this.setApprovalMode(n.getStringValue()));
        deserializerMap.put("approvalStages", n -> this.setApprovalStages(n.getCollectionOfObjectValues(UnifiedApprovalStage::createFromDiscriminatorValue)));
        deserializerMap.put("isApprovalRequired", n -> this.setIsApprovalRequired(n.getBooleanValue()));
        deserializerMap.put("isApprovalRequiredForExtension", n -> this.setIsApprovalRequiredForExtension(n.getBooleanValue()));
        deserializerMap.put("isRequestorJustificationRequired", n -> this.setIsRequestorJustificationRequired(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsApprovalRequired() {
        return (Boolean)this.backingStore.get("isApprovalRequired");
    }

    @Nullable
    public Boolean getIsApprovalRequiredForExtension() {
        return (Boolean)this.backingStore.get("isApprovalRequiredForExtension");
    }

    @Nullable
    public Boolean getIsRequestorJustificationRequired() {
        return (Boolean)this.backingStore.get("isRequestorJustificationRequired");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("approvalMode", this.getApprovalMode());
        writer.writeCollectionOfObjectValues("approvalStages", this.getApprovalStages());
        writer.writeBooleanValue("isApprovalRequired", this.getIsApprovalRequired());
        writer.writeBooleanValue("isApprovalRequiredForExtension", this.getIsApprovalRequiredForExtension());
        writer.writeBooleanValue("isRequestorJustificationRequired", this.getIsRequestorJustificationRequired());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setApprovalMode(@Nullable String value) {
        this.backingStore.set("approvalMode", (Object)value);
    }

    public void setApprovalStages(@Nullable List<UnifiedApprovalStage> value) {
        this.backingStore.set("approvalStages", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setIsApprovalRequired(@Nullable Boolean value) {
        this.backingStore.set("isApprovalRequired", (Object)value);
    }

    public void setIsApprovalRequiredForExtension(@Nullable Boolean value) {
        this.backingStore.set("isApprovalRequiredForExtension", (Object)value);
    }

    public void setIsRequestorJustificationRequired(@Nullable Boolean value) {
        this.backingStore.set("isRequestorJustificationRequired", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

