/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.security.Article;
import com.microsoft.graph.models.security.CvssSummary;
import com.microsoft.graph.models.security.FormattedContent;
import com.microsoft.graph.models.security.Hyperlink;
import com.microsoft.graph.models.security.VulnerabilityComponent;
import com.microsoft.graph.models.security.VulnerabilitySeverity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Vulnerability
extends Entity
implements Parsable {
    @Nonnull
    public static Vulnerability createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Vulnerability();
    }

    @Nullable
    public Boolean getActiveExploitsObserved() {
        return (Boolean)this.backingStore.get("activeExploitsObserved");
    }

    @Nullable
    public List<Article> getArticles() {
        return (List)this.backingStore.get("articles");
    }

    @Nullable
    public List<String> getCommonWeaknessEnumerationIds() {
        return (List)this.backingStore.get("commonWeaknessEnumerationIds");
    }

    @Nullable
    public List<VulnerabilityComponent> getComponents() {
        return (List)this.backingStore.get("components");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public CvssSummary getCvss2Summary() {
        return (CvssSummary)this.backingStore.get("cvss2Summary");
    }

    @Nullable
    public CvssSummary getCvss3Summary() {
        return (CvssSummary)this.backingStore.get("cvss3Summary");
    }

    @Nullable
    public FormattedContent getDescription() {
        return (FormattedContent)this.backingStore.get("description");
    }

    @Nullable
    public List<Hyperlink> getExploits() {
        return (List)this.backingStore.get("exploits");
    }

    @Nullable
    public Boolean getExploitsAvailable() {
        return (Boolean)this.backingStore.get("exploitsAvailable");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("activeExploitsObserved", n -> this.setActiveExploitsObserved(n.getBooleanValue()));
        deserializerMap.put("articles", n -> this.setArticles(n.getCollectionOfObjectValues(Article::createFromDiscriminatorValue)));
        deserializerMap.put("commonWeaknessEnumerationIds", n -> this.setCommonWeaknessEnumerationIds(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("components", n -> this.setComponents(n.getCollectionOfObjectValues(VulnerabilityComponent::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("cvss2Summary", n -> this.setCvss2Summary((CvssSummary)n.getObjectValue(CvssSummary::createFromDiscriminatorValue)));
        deserializerMap.put("cvss3Summary", n -> this.setCvss3Summary((CvssSummary)n.getObjectValue(CvssSummary::createFromDiscriminatorValue)));
        deserializerMap.put("description", n -> this.setDescription((FormattedContent)n.getObjectValue(FormattedContent::createFromDiscriminatorValue)));
        deserializerMap.put("exploits", n -> this.setExploits(n.getCollectionOfObjectValues(Hyperlink::createFromDiscriminatorValue)));
        deserializerMap.put("exploitsAvailable", n -> this.setExploitsAvailable(n.getBooleanValue()));
        deserializerMap.put("hasChatter", n -> this.setHasChatter(n.getBooleanValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("priorityScore", n -> this.setPriorityScore(n.getIntegerValue()));
        deserializerMap.put("publishedDateTime", n -> this.setPublishedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("references", n -> this.setReferences(n.getCollectionOfObjectValues(Hyperlink::createFromDiscriminatorValue)));
        deserializerMap.put("remediation", n -> this.setRemediation((FormattedContent)n.getObjectValue(FormattedContent::createFromDiscriminatorValue)));
        deserializerMap.put("severity", n -> this.setSeverity((VulnerabilitySeverity)n.getEnumValue(VulnerabilitySeverity::forValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getHasChatter() {
        return (Boolean)this.backingStore.get("hasChatter");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public Integer getPriorityScore() {
        return (Integer)this.backingStore.get("priorityScore");
    }

    @Nullable
    public OffsetDateTime getPublishedDateTime() {
        return (OffsetDateTime)this.backingStore.get("publishedDateTime");
    }

    @Nullable
    public List<Hyperlink> getReferences() {
        return (List)this.backingStore.get("references");
    }

    @Nullable
    public FormattedContent getRemediation() {
        return (FormattedContent)this.backingStore.get("remediation");
    }

    @Nullable
    public VulnerabilitySeverity getSeverity() {
        return (VulnerabilitySeverity)((Object)this.backingStore.get("severity"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeBooleanValue("activeExploitsObserved", this.getActiveExploitsObserved());
        writer.writeCollectionOfObjectValues("articles", this.getArticles());
        writer.writeCollectionOfPrimitiveValues("commonWeaknessEnumerationIds", this.getCommonWeaknessEnumerationIds());
        writer.writeCollectionOfObjectValues("components", this.getComponents());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeObjectValue("cvss2Summary", (Parsable)this.getCvss2Summary(), new Parsable[0]);
        writer.writeObjectValue("cvss3Summary", (Parsable)this.getCvss3Summary(), new Parsable[0]);
        writer.writeObjectValue("description", (Parsable)this.getDescription(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("exploits", this.getExploits());
        writer.writeBooleanValue("exploitsAvailable", this.getExploitsAvailable());
        writer.writeBooleanValue("hasChatter", this.getHasChatter());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeIntegerValue("priorityScore", this.getPriorityScore());
        writer.writeOffsetDateTimeValue("publishedDateTime", this.getPublishedDateTime());
        writer.writeCollectionOfObjectValues("references", this.getReferences());
        writer.writeObjectValue("remediation", (Parsable)this.getRemediation(), new Parsable[0]);
        writer.writeEnumValue("severity", (Enum)this.getSeverity());
    }

    public void setActiveExploitsObserved(@Nullable Boolean value) {
        this.backingStore.set("activeExploitsObserved", (Object)value);
    }

    public void setArticles(@Nullable List<Article> value) {
        this.backingStore.set("articles", value);
    }

    public void setCommonWeaknessEnumerationIds(@Nullable List<String> value) {
        this.backingStore.set("commonWeaknessEnumerationIds", value);
    }

    public void setComponents(@Nullable List<VulnerabilityComponent> value) {
        this.backingStore.set("components", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setCvss2Summary(@Nullable CvssSummary value) {
        this.backingStore.set("cvss2Summary", (Object)value);
    }

    public void setCvss3Summary(@Nullable CvssSummary value) {
        this.backingStore.set("cvss3Summary", (Object)value);
    }

    public void setDescription(@Nullable FormattedContent value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setExploits(@Nullable List<Hyperlink> value) {
        this.backingStore.set("exploits", value);
    }

    public void setExploitsAvailable(@Nullable Boolean value) {
        this.backingStore.set("exploitsAvailable", (Object)value);
    }

    public void setHasChatter(@Nullable Boolean value) {
        this.backingStore.set("hasChatter", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setPriorityScore(@Nullable Integer value) {
        this.backingStore.set("priorityScore", (Object)value);
    }

    public void setPublishedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("publishedDateTime", (Object)value);
    }

    public void setReferences(@Nullable List<Hyperlink> value) {
        this.backingStore.set("references", value);
    }

    public void setRemediation(@Nullable FormattedContent value) {
        this.backingStore.set("remediation", (Object)value);
    }

    public void setSeverity(@Nullable VulnerabilitySeverity value) {
        this.backingStore.set("severity", (Object)value);
    }
}

