/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.DefenderAvStatus;
import com.microsoft.graph.models.security.DeviceHealthStatus;
import com.microsoft.graph.models.security.DeviceRiskScore;
import com.microsoft.graph.models.security.LoggedOnUser;
import com.microsoft.graph.models.security.OnboardingStatus;
import com.microsoft.graph.models.security.VmMetadata;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DeviceEvidence
extends AlertEvidence
implements Parsable {
    public DeviceEvidence() {
        this.setOdataType("#microsoft.graph.security.deviceEvidence");
    }

    @Nonnull
    public static DeviceEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DeviceEvidence();
    }

    @Nullable
    public String getAzureAdDeviceId() {
        return (String)this.backingStore.get("azureAdDeviceId");
    }

    @Nullable
    public DefenderAvStatus getDefenderAvStatus() {
        return (DefenderAvStatus)((Object)this.backingStore.get("defenderAvStatus"));
    }

    @Nullable
    public String getDeviceDnsName() {
        return (String)this.backingStore.get("deviceDnsName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("azureAdDeviceId", n -> this.setAzureAdDeviceId(n.getStringValue()));
        deserializerMap.put("defenderAvStatus", n -> this.setDefenderAvStatus((DefenderAvStatus)n.getEnumValue(DefenderAvStatus::forValue)));
        deserializerMap.put("deviceDnsName", n -> this.setDeviceDnsName(n.getStringValue()));
        deserializerMap.put("firstSeenDateTime", n -> this.setFirstSeenDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("healthStatus", n -> this.setHealthStatus((DeviceHealthStatus)n.getEnumValue(DeviceHealthStatus::forValue)));
        deserializerMap.put("ipInterfaces", n -> this.setIpInterfaces(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("lastExternalIpAddress", n -> this.setLastExternalIpAddress(n.getStringValue()));
        deserializerMap.put("lastIpAddress", n -> this.setLastIpAddress(n.getStringValue()));
        deserializerMap.put("loggedOnUsers", n -> this.setLoggedOnUsers(n.getCollectionOfObjectValues(LoggedOnUser::createFromDiscriminatorValue)));
        deserializerMap.put("mdeDeviceId", n -> this.setMdeDeviceId(n.getStringValue()));
        deserializerMap.put("onboardingStatus", n -> this.setOnboardingStatus((OnboardingStatus)n.getEnumValue(OnboardingStatus::forValue)));
        deserializerMap.put("osBuild", n -> this.setOsBuild(n.getLongValue()));
        deserializerMap.put("osPlatform", n -> this.setOsPlatform(n.getStringValue()));
        deserializerMap.put("rbacGroupId", n -> this.setRbacGroupId(n.getIntegerValue()));
        deserializerMap.put("rbacGroupName", n -> this.setRbacGroupName(n.getStringValue()));
        deserializerMap.put("riskScore", n -> this.setRiskScore((DeviceRiskScore)n.getEnumValue(DeviceRiskScore::forValue)));
        deserializerMap.put("version", n -> this.setVersion(n.getStringValue()));
        deserializerMap.put("vmMetadata", n -> this.setVmMetadata((VmMetadata)n.getObjectValue(VmMetadata::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getFirstSeenDateTime() {
        return (OffsetDateTime)this.backingStore.get("firstSeenDateTime");
    }

    @Nullable
    public DeviceHealthStatus getHealthStatus() {
        return (DeviceHealthStatus)((Object)this.backingStore.get("healthStatus"));
    }

    @Nullable
    public List<String> getIpInterfaces() {
        return (List)this.backingStore.get("ipInterfaces");
    }

    @Nullable
    public String getLastExternalIpAddress() {
        return (String)this.backingStore.get("lastExternalIpAddress");
    }

    @Nullable
    public String getLastIpAddress() {
        return (String)this.backingStore.get("lastIpAddress");
    }

    @Nullable
    public List<LoggedOnUser> getLoggedOnUsers() {
        return (List)this.backingStore.get("loggedOnUsers");
    }

    @Nullable
    public String getMdeDeviceId() {
        return (String)this.backingStore.get("mdeDeviceId");
    }

    @Nullable
    public OnboardingStatus getOnboardingStatus() {
        return (OnboardingStatus)((Object)this.backingStore.get("onboardingStatus"));
    }

    @Nullable
    public Long getOsBuild() {
        return (Long)this.backingStore.get("osBuild");
    }

    @Nullable
    public String getOsPlatform() {
        return (String)this.backingStore.get("osPlatform");
    }

    @Nullable
    public Integer getRbacGroupId() {
        return (Integer)this.backingStore.get("rbacGroupId");
    }

    @Nullable
    public String getRbacGroupName() {
        return (String)this.backingStore.get("rbacGroupName");
    }

    @Nullable
    public DeviceRiskScore getRiskScore() {
        return (DeviceRiskScore)((Object)this.backingStore.get("riskScore"));
    }

    @Nullable
    public String getVersion() {
        return (String)this.backingStore.get("version");
    }

    @Nullable
    public VmMetadata getVmMetadata() {
        return (VmMetadata)this.backingStore.get("vmMetadata");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("azureAdDeviceId", this.getAzureAdDeviceId());
        writer.writeEnumValue("defenderAvStatus", (Enum)this.getDefenderAvStatus());
        writer.writeStringValue("deviceDnsName", this.getDeviceDnsName());
        writer.writeOffsetDateTimeValue("firstSeenDateTime", this.getFirstSeenDateTime());
        writer.writeEnumValue("healthStatus", (Enum)this.getHealthStatus());
        writer.writeCollectionOfPrimitiveValues("ipInterfaces", this.getIpInterfaces());
        writer.writeStringValue("lastExternalIpAddress", this.getLastExternalIpAddress());
        writer.writeStringValue("lastIpAddress", this.getLastIpAddress());
        writer.writeCollectionOfObjectValues("loggedOnUsers", this.getLoggedOnUsers());
        writer.writeStringValue("mdeDeviceId", this.getMdeDeviceId());
        writer.writeEnumValue("onboardingStatus", (Enum)this.getOnboardingStatus());
        writer.writeLongValue("osBuild", this.getOsBuild());
        writer.writeStringValue("osPlatform", this.getOsPlatform());
        writer.writeIntegerValue("rbacGroupId", this.getRbacGroupId());
        writer.writeStringValue("rbacGroupName", this.getRbacGroupName());
        writer.writeEnumValue("riskScore", (Enum)this.getRiskScore());
        writer.writeStringValue("version", this.getVersion());
        writer.writeObjectValue("vmMetadata", (Parsable)this.getVmMetadata(), new Parsable[0]);
    }

    public void setAzureAdDeviceId(@Nullable String value) {
        this.backingStore.set("azureAdDeviceId", (Object)value);
    }

    public void setDefenderAvStatus(@Nullable DefenderAvStatus value) {
        this.backingStore.set("defenderAvStatus", (Object)value);
    }

    public void setDeviceDnsName(@Nullable String value) {
        this.backingStore.set("deviceDnsName", (Object)value);
    }

    public void setFirstSeenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("firstSeenDateTime", (Object)value);
    }

    public void setHealthStatus(@Nullable DeviceHealthStatus value) {
        this.backingStore.set("healthStatus", (Object)value);
    }

    public void setIpInterfaces(@Nullable List<String> value) {
        this.backingStore.set("ipInterfaces", value);
    }

    public void setLastExternalIpAddress(@Nullable String value) {
        this.backingStore.set("lastExternalIpAddress", (Object)value);
    }

    public void setLastIpAddress(@Nullable String value) {
        this.backingStore.set("lastIpAddress", (Object)value);
    }

    public void setLoggedOnUsers(@Nullable List<LoggedOnUser> value) {
        this.backingStore.set("loggedOnUsers", value);
    }

    public void setMdeDeviceId(@Nullable String value) {
        this.backingStore.set("mdeDeviceId", (Object)value);
    }

    public void setOnboardingStatus(@Nullable OnboardingStatus value) {
        this.backingStore.set("onboardingStatus", (Object)value);
    }

    public void setOsBuild(@Nullable Long value) {
        this.backingStore.set("osBuild", (Object)value);
    }

    public void setOsPlatform(@Nullable String value) {
        this.backingStore.set("osPlatform", (Object)value);
    }

    public void setRbacGroupId(@Nullable Integer value) {
        this.backingStore.set("rbacGroupId", (Object)value);
    }

    public void setRbacGroupName(@Nullable String value) {
        this.backingStore.set("rbacGroupName", (Object)value);
    }

    public void setRiskScore(@Nullable DeviceRiskScore value) {
        this.backingStore.set("riskScore", (Object)value);
    }

    public void setVersion(@Nullable String value) {
        this.backingStore.set("version", (Object)value);
    }

    public void setVmMetadata(@Nullable VmMetadata value) {
        this.backingStore.set("vmMetadata", (Object)value);
    }
}

