/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.security.AlertClassification;
import com.microsoft.graph.models.security.AlertComment;
import com.microsoft.graph.models.security.AlertDetermination;
import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.AlertSeverity;
import com.microsoft.graph.models.security.AlertStatus;
import com.microsoft.graph.models.security.DetectionSource;
import com.microsoft.graph.models.security.Dictionary;
import com.microsoft.graph.models.security.ServiceSource;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Alert
extends Entity
implements Parsable {
    @Nonnull
    public static Alert createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Alert();
    }

    @Nullable
    public String getActorDisplayName() {
        return (String)this.backingStore.get("actorDisplayName");
    }

    @Nullable
    public Dictionary getAdditionalDataProperty() {
        return (Dictionary)this.backingStore.get("additionalDataProperty");
    }

    @Nullable
    public String getAlertPolicyId() {
        return (String)this.backingStore.get("alertPolicyId");
    }

    @Nullable
    public String getAlertWebUrl() {
        return (String)this.backingStore.get("alertWebUrl");
    }

    @Nullable
    public String getAssignedTo() {
        return (String)this.backingStore.get("assignedTo");
    }

    @Nullable
    public String getCategory() {
        return (String)this.backingStore.get("category");
    }

    @Nullable
    public AlertClassification getClassification() {
        return (AlertClassification)((Object)this.backingStore.get("classification"));
    }

    @Nullable
    public List<AlertComment> getComments() {
        return (List)this.backingStore.get("comments");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public DetectionSource getDetectionSource() {
        return (DetectionSource)((Object)this.backingStore.get("detectionSource"));
    }

    @Nullable
    public String getDetectorId() {
        return (String)this.backingStore.get("detectorId");
    }

    @Nullable
    public AlertDetermination getDetermination() {
        return (AlertDetermination)((Object)this.backingStore.get("determination"));
    }

    @Nullable
    public List<AlertEvidence> getEvidence() {
        return (List)this.backingStore.get("evidence");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("actorDisplayName", n -> this.setActorDisplayName(n.getStringValue()));
        deserializerMap.put("additionalData", n -> this.setAdditionalDataProperty((Dictionary)n.getObjectValue(Dictionary::createFromDiscriminatorValue)));
        deserializerMap.put("alertPolicyId", n -> this.setAlertPolicyId(n.getStringValue()));
        deserializerMap.put("alertWebUrl", n -> this.setAlertWebUrl(n.getStringValue()));
        deserializerMap.put("assignedTo", n -> this.setAssignedTo(n.getStringValue()));
        deserializerMap.put("category", n -> this.setCategory(n.getStringValue()));
        deserializerMap.put("classification", n -> this.setClassification((AlertClassification)n.getEnumValue(AlertClassification::forValue)));
        deserializerMap.put("comments", n -> this.setComments(n.getCollectionOfObjectValues(AlertComment::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("detectionSource", n -> this.setDetectionSource((DetectionSource)n.getEnumValue(DetectionSource::forValue)));
        deserializerMap.put("detectorId", n -> this.setDetectorId(n.getStringValue()));
        deserializerMap.put("determination", n -> this.setDetermination((AlertDetermination)n.getEnumValue(AlertDetermination::forValue)));
        deserializerMap.put("evidence", n -> this.setEvidence(n.getCollectionOfObjectValues(AlertEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("firstActivityDateTime", n -> this.setFirstActivityDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("incidentId", n -> this.setIncidentId(n.getStringValue()));
        deserializerMap.put("incidentWebUrl", n -> this.setIncidentWebUrl(n.getStringValue()));
        deserializerMap.put("lastActivityDateTime", n -> this.setLastActivityDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastUpdateDateTime", n -> this.setLastUpdateDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("mitreTechniques", n -> this.setMitreTechniques(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("productName", n -> this.setProductName(n.getStringValue()));
        deserializerMap.put("providerAlertId", n -> this.setProviderAlertId(n.getStringValue()));
        deserializerMap.put("recommendedActions", n -> this.setRecommendedActions(n.getStringValue()));
        deserializerMap.put("resolvedDateTime", n -> this.setResolvedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("serviceSource", n -> this.setServiceSource((ServiceSource)n.getEnumValue(ServiceSource::forValue)));
        deserializerMap.put("severity", n -> this.setSeverity((AlertSeverity)n.getEnumValue(AlertSeverity::forValue)));
        deserializerMap.put("status", n -> this.setStatus((AlertStatus)n.getEnumValue(AlertStatus::forValue)));
        deserializerMap.put("systemTags", n -> this.setSystemTags(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("tenantId", n -> this.setTenantId(n.getStringValue()));
        deserializerMap.put("threatDisplayName", n -> this.setThreatDisplayName(n.getStringValue()));
        deserializerMap.put("threatFamilyName", n -> this.setThreatFamilyName(n.getStringValue()));
        deserializerMap.put("title", n -> this.setTitle(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getFirstActivityDateTime() {
        return (OffsetDateTime)this.backingStore.get("firstActivityDateTime");
    }

    @Nullable
    public String getIncidentId() {
        return (String)this.backingStore.get("incidentId");
    }

    @Nullable
    public String getIncidentWebUrl() {
        return (String)this.backingStore.get("incidentWebUrl");
    }

    @Nullable
    public OffsetDateTime getLastActivityDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastActivityDateTime");
    }

    @Nullable
    public OffsetDateTime getLastUpdateDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastUpdateDateTime");
    }

    @Nullable
    public List<String> getMitreTechniques() {
        return (List)this.backingStore.get("mitreTechniques");
    }

    @Nullable
    public String getProductName() {
        return (String)this.backingStore.get("productName");
    }

    @Nullable
    public String getProviderAlertId() {
        return (String)this.backingStore.get("providerAlertId");
    }

    @Nullable
    public String getRecommendedActions() {
        return (String)this.backingStore.get("recommendedActions");
    }

    @Nullable
    public OffsetDateTime getResolvedDateTime() {
        return (OffsetDateTime)this.backingStore.get("resolvedDateTime");
    }

    @Nullable
    public ServiceSource getServiceSource() {
        return (ServiceSource)((Object)this.backingStore.get("serviceSource"));
    }

    @Nullable
    public AlertSeverity getSeverity() {
        return (AlertSeverity)((Object)this.backingStore.get("severity"));
    }

    @Nullable
    public AlertStatus getStatus() {
        return (AlertStatus)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public List<String> getSystemTags() {
        return (List)this.backingStore.get("systemTags");
    }

    @Nullable
    public String getTenantId() {
        return (String)this.backingStore.get("tenantId");
    }

    @Nullable
    public String getThreatDisplayName() {
        return (String)this.backingStore.get("threatDisplayName");
    }

    @Nullable
    public String getThreatFamilyName() {
        return (String)this.backingStore.get("threatFamilyName");
    }

    @Nullable
    public String getTitle() {
        return (String)this.backingStore.get("title");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("actorDisplayName", this.getActorDisplayName());
        writer.writeObjectValue("additionalData", (Parsable)this.getAdditionalDataProperty(), new Parsable[0]);
        writer.writeStringValue("alertPolicyId", this.getAlertPolicyId());
        writer.writeStringValue("alertWebUrl", this.getAlertWebUrl());
        writer.writeStringValue("assignedTo", this.getAssignedTo());
        writer.writeStringValue("category", this.getCategory());
        writer.writeEnumValue("classification", (Enum)this.getClassification());
        writer.writeCollectionOfObjectValues("comments", this.getComments());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeEnumValue("detectionSource", (Enum)this.getDetectionSource());
        writer.writeStringValue("detectorId", this.getDetectorId());
        writer.writeEnumValue("determination", (Enum)this.getDetermination());
        writer.writeCollectionOfObjectValues("evidence", this.getEvidence());
        writer.writeOffsetDateTimeValue("firstActivityDateTime", this.getFirstActivityDateTime());
        writer.writeStringValue("incidentId", this.getIncidentId());
        writer.writeStringValue("incidentWebUrl", this.getIncidentWebUrl());
        writer.writeOffsetDateTimeValue("lastActivityDateTime", this.getLastActivityDateTime());
        writer.writeOffsetDateTimeValue("lastUpdateDateTime", this.getLastUpdateDateTime());
        writer.writeCollectionOfPrimitiveValues("mitreTechniques", this.getMitreTechniques());
        writer.writeStringValue("productName", this.getProductName());
        writer.writeStringValue("providerAlertId", this.getProviderAlertId());
        writer.writeStringValue("recommendedActions", this.getRecommendedActions());
        writer.writeOffsetDateTimeValue("resolvedDateTime", this.getResolvedDateTime());
        writer.writeEnumValue("serviceSource", (Enum)this.getServiceSource());
        writer.writeEnumValue("severity", (Enum)this.getSeverity());
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeCollectionOfPrimitiveValues("systemTags", this.getSystemTags());
        writer.writeStringValue("tenantId", this.getTenantId());
        writer.writeStringValue("threatDisplayName", this.getThreatDisplayName());
        writer.writeStringValue("threatFamilyName", this.getThreatFamilyName());
        writer.writeStringValue("title", this.getTitle());
    }

    public void setActorDisplayName(@Nullable String value) {
        this.backingStore.set("actorDisplayName", (Object)value);
    }

    public void setAdditionalDataProperty(@Nullable Dictionary value) {
        this.backingStore.set("additionalDataProperty", (Object)value);
    }

    public void setAlertPolicyId(@Nullable String value) {
        this.backingStore.set("alertPolicyId", (Object)value);
    }

    public void setAlertWebUrl(@Nullable String value) {
        this.backingStore.set("alertWebUrl", (Object)value);
    }

    public void setAssignedTo(@Nullable String value) {
        this.backingStore.set("assignedTo", (Object)value);
    }

    public void setCategory(@Nullable String value) {
        this.backingStore.set("category", (Object)value);
    }

    public void setClassification(@Nullable AlertClassification value) {
        this.backingStore.set("classification", (Object)value);
    }

    public void setComments(@Nullable List<AlertComment> value) {
        this.backingStore.set("comments", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDetectionSource(@Nullable DetectionSource value) {
        this.backingStore.set("detectionSource", (Object)value);
    }

    public void setDetectorId(@Nullable String value) {
        this.backingStore.set("detectorId", (Object)value);
    }

    public void setDetermination(@Nullable AlertDetermination value) {
        this.backingStore.set("determination", (Object)value);
    }

    public void setEvidence(@Nullable List<AlertEvidence> value) {
        this.backingStore.set("evidence", value);
    }

    public void setFirstActivityDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("firstActivityDateTime", (Object)value);
    }

    public void setIncidentId(@Nullable String value) {
        this.backingStore.set("incidentId", (Object)value);
    }

    public void setIncidentWebUrl(@Nullable String value) {
        this.backingStore.set("incidentWebUrl", (Object)value);
    }

    public void setLastActivityDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastActivityDateTime", (Object)value);
    }

    public void setLastUpdateDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastUpdateDateTime", (Object)value);
    }

    public void setMitreTechniques(@Nullable List<String> value) {
        this.backingStore.set("mitreTechniques", value);
    }

    public void setProductName(@Nullable String value) {
        this.backingStore.set("productName", (Object)value);
    }

    public void setProviderAlertId(@Nullable String value) {
        this.backingStore.set("providerAlertId", (Object)value);
    }

    public void setRecommendedActions(@Nullable String value) {
        this.backingStore.set("recommendedActions", (Object)value);
    }

    public void setResolvedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("resolvedDateTime", (Object)value);
    }

    public void setServiceSource(@Nullable ServiceSource value) {
        this.backingStore.set("serviceSource", (Object)value);
    }

    public void setSeverity(@Nullable AlertSeverity value) {
        this.backingStore.set("severity", (Object)value);
    }

    public void setStatus(@Nullable AlertStatus value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setSystemTags(@Nullable List<String> value) {
        this.backingStore.set("systemTags", value);
    }

    public void setTenantId(@Nullable String value) {
        this.backingStore.set("tenantId", (Object)value);
    }

    public void setThreatDisplayName(@Nullable String value) {
        this.backingStore.set("threatDisplayName", (Object)value);
    }

    public void setThreatFamilyName(@Nullable String value) {
        this.backingStore.set("threatFamilyName", (Object)value);
    }

    public void setTitle(@Nullable String value) {
        this.backingStore.set("title", (Object)value);
    }
}

