/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BaseItem;
import com.microsoft.graph.models.PageLayoutType;
import com.microsoft.graph.models.PublicationFacet;
import com.microsoft.graph.models.SitePage;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BaseSitePage
extends BaseItem
implements Parsable {
    public BaseSitePage() {
        this.setOdataType("#microsoft.graph.baseSitePage");
    }

    @Nonnull
    public static BaseSitePage createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.sitePage": {
                    return new SitePage();
                }
            }
        }
        return new BaseSitePage();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("pageLayout", n -> this.setPageLayout((PageLayoutType)n.getEnumValue(PageLayoutType::forValue)));
        deserializerMap.put("publishingState", n -> this.setPublishingState((PublicationFacet)n.getObjectValue(PublicationFacet::createFromDiscriminatorValue)));
        deserializerMap.put("title", n -> this.setTitle(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public PageLayoutType getPageLayout() {
        return (PageLayoutType)((Object)this.backingStore.get("pageLayout"));
    }

    @Nullable
    public PublicationFacet getPublishingState() {
        return (PublicationFacet)this.backingStore.get("publishingState");
    }

    @Nullable
    public String getTitle() {
        return (String)this.backingStore.get("title");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeEnumValue("pageLayout", (Enum)this.getPageLayout());
        writer.writeObjectValue("publishingState", (Parsable)this.getPublishingState(), new Parsable[0]);
        writer.writeStringValue("title", this.getTitle());
    }

    public void setPageLayout(@Nullable PageLayoutType value) {
        this.backingStore.set("pageLayout", (Object)value);
    }

    public void setPublishingState(@Nullable PublicationFacet value) {
        this.backingStore.set("publishingState", (Object)value);
    }

    public void setTitle(@Nullable String value) {
        this.backingStore.set("title", (Object)value);
    }
}

