/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.Dictionary;
import com.microsoft.graph.models.security.IpEvidence;
import com.microsoft.graph.models.security.KubernetesNamespaceEvidence;
import com.microsoft.graph.models.security.KubernetesServicePort;
import com.microsoft.graph.models.security.KubernetesServiceType;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class KubernetesServiceEvidence
extends AlertEvidence
implements Parsable {
    public KubernetesServiceEvidence() {
        this.setOdataType("#microsoft.graph.security.kubernetesServiceEvidence");
    }

    @Nonnull
    public static KubernetesServiceEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new KubernetesServiceEvidence();
    }

    @Nullable
    public IpEvidence getClusterIP() {
        return (IpEvidence)this.backingStore.get("clusterIP");
    }

    @Nullable
    public List<IpEvidence> getExternalIPs() {
        return (List)this.backingStore.get("externalIPs");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("clusterIP", n -> this.setClusterIP((IpEvidence)n.getObjectValue(IpEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("externalIPs", n -> this.setExternalIPs(n.getCollectionOfObjectValues(IpEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("labels", n -> this.setLabels((Dictionary)n.getObjectValue(Dictionary::createFromDiscriminatorValue)));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("namespace", n -> this.setNamespace((KubernetesNamespaceEvidence)n.getObjectValue(KubernetesNamespaceEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("selector", n -> this.setSelector((Dictionary)n.getObjectValue(Dictionary::createFromDiscriminatorValue)));
        deserializerMap.put("servicePorts", n -> this.setServicePorts(n.getCollectionOfObjectValues(KubernetesServicePort::createFromDiscriminatorValue)));
        deserializerMap.put("serviceType", n -> this.setServiceType((KubernetesServiceType)n.getEnumValue(KubernetesServiceType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public Dictionary getLabels() {
        return (Dictionary)this.backingStore.get("labels");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public KubernetesNamespaceEvidence getNamespace() {
        return (KubernetesNamespaceEvidence)this.backingStore.get("namespace");
    }

    @Nullable
    public Dictionary getSelector() {
        return (Dictionary)this.backingStore.get("selector");
    }

    @Nullable
    public List<KubernetesServicePort> getServicePorts() {
        return (List)this.backingStore.get("servicePorts");
    }

    @Nullable
    public KubernetesServiceType getServiceType() {
        return (KubernetesServiceType)((Object)this.backingStore.get("serviceType"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("clusterIP", (Parsable)this.getClusterIP(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("externalIPs", this.getExternalIPs());
        writer.writeObjectValue("labels", (Parsable)this.getLabels(), new Parsable[0]);
        writer.writeStringValue("name", this.getName());
        writer.writeObjectValue("namespace", (Parsable)this.getNamespace(), new Parsable[0]);
        writer.writeObjectValue("selector", (Parsable)this.getSelector(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("servicePorts", this.getServicePorts());
        writer.writeEnumValue("serviceType", (Enum)this.getServiceType());
    }

    public void setClusterIP(@Nullable IpEvidence value) {
        this.backingStore.set("clusterIP", (Object)value);
    }

    public void setExternalIPs(@Nullable List<IpEvidence> value) {
        this.backingStore.set("externalIPs", value);
    }

    public void setLabels(@Nullable Dictionary value) {
        this.backingStore.set("labels", (Object)value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setNamespace(@Nullable KubernetesNamespaceEvidence value) {
        this.backingStore.set("namespace", (Object)value);
    }

    public void setSelector(@Nullable Dictionary value) {
        this.backingStore.set("selector", (Object)value);
    }

    public void setServicePorts(@Nullable List<KubernetesServicePort> value) {
        this.backingStore.set("servicePorts", value);
    }

    public void setServiceType(@Nullable KubernetesServiceType value) {
        this.backingStore.set("serviceType", (Object)value);
    }
}

