/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.identitygovernance;

import com.microsoft.graph.models.User;
import com.microsoft.graph.models.identitygovernance.LifecycleWorkflowCategory;
import com.microsoft.graph.models.identitygovernance.Task;
import com.microsoft.graph.models.identitygovernance.Workflow;
import com.microsoft.graph.models.identitygovernance.WorkflowExecutionConditions;
import com.microsoft.graph.models.identitygovernance.WorkflowVersion;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WorkflowBase
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public WorkflowBase() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static WorkflowBase createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.identityGovernance.workflow": {
                    return new Workflow();
                }
                case "#microsoft.graph.identityGovernance.workflowVersion": {
                    return new WorkflowVersion();
                }
            }
        }
        return new WorkflowBase();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public LifecycleWorkflowCategory getCategory() {
        return (LifecycleWorkflowCategory)((Object)this.backingStore.get("category"));
    }

    @Nullable
    public User getCreatedBy() {
        return (User)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public WorkflowExecutionConditions getExecutionConditions() {
        return (WorkflowExecutionConditions)this.backingStore.get("executionConditions");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(12);
        deserializerMap.put("category", n -> this.setCategory((LifecycleWorkflowCategory)n.getEnumValue(LifecycleWorkflowCategory::forValue)));
        deserializerMap.put("createdBy", n -> this.setCreatedBy((User)n.getObjectValue(User::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("executionConditions", n -> this.setExecutionConditions((WorkflowExecutionConditions)n.getObjectValue(WorkflowExecutionConditions::createFromDiscriminatorValue)));
        deserializerMap.put("isEnabled", n -> this.setIsEnabled(n.getBooleanValue()));
        deserializerMap.put("isSchedulingEnabled", n -> this.setIsSchedulingEnabled(n.getBooleanValue()));
        deserializerMap.put("lastModifiedBy", n -> this.setLastModifiedBy((User)n.getObjectValue(User::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("tasks", n -> this.setTasks(n.getCollectionOfObjectValues(Task::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsEnabled() {
        return (Boolean)this.backingStore.get("isEnabled");
    }

    @Nullable
    public Boolean getIsSchedulingEnabled() {
        return (Boolean)this.backingStore.get("isSchedulingEnabled");
    }

    @Nullable
    public User getLastModifiedBy() {
        return (User)this.backingStore.get("lastModifiedBy");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<Task> getTasks() {
        return (List)this.backingStore.get("tasks");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumValue("category", (Enum)this.getCategory());
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("executionConditions", (Parsable)this.getExecutionConditions(), new Parsable[0]);
        writer.writeBooleanValue("isEnabled", this.getIsEnabled());
        writer.writeBooleanValue("isSchedulingEnabled", this.getIsSchedulingEnabled());
        writer.writeObjectValue("lastModifiedBy", (Parsable)this.getLastModifiedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("tasks", this.getTasks());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCategory(@Nullable LifecycleWorkflowCategory value) {
        this.backingStore.set("category", (Object)value);
    }

    public void setCreatedBy(@Nullable User value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setExecutionConditions(@Nullable WorkflowExecutionConditions value) {
        this.backingStore.set("executionConditions", (Object)value);
    }

    public void setIsEnabled(@Nullable Boolean value) {
        this.backingStore.set("isEnabled", (Object)value);
    }

    public void setIsSchedulingEnabled(@Nullable Boolean value) {
        this.backingStore.set("isSchedulingEnabled", (Object)value);
    }

    public void setLastModifiedBy(@Nullable User value) {
        this.backingStore.set("lastModifiedBy", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setTasks(@Nullable List<Task> value) {
        this.backingStore.set("tasks", value);
    }
}

