/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TextColumn
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public TextColumn() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static TextColumn createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new TextColumn();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public Boolean getAllowMultipleLines() {
        return (Boolean)this.backingStore.get("allowMultipleLines");
    }

    @Nullable
    public Boolean getAppendChangesToExistingText() {
        return (Boolean)this.backingStore.get("appendChangesToExistingText");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("allowMultipleLines", n -> this.setAllowMultipleLines(n.getBooleanValue()));
        deserializerMap.put("appendChangesToExistingText", n -> this.setAppendChangesToExistingText(n.getBooleanValue()));
        deserializerMap.put("linesForEditing", n -> this.setLinesForEditing(n.getIntegerValue()));
        deserializerMap.put("maxLength", n -> this.setMaxLength(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("textType", n -> this.setTextType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Integer getLinesForEditing() {
        return (Integer)this.backingStore.get("linesForEditing");
    }

    @Nullable
    public Integer getMaxLength() {
        return (Integer)this.backingStore.get("maxLength");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getTextType() {
        return (String)this.backingStore.get("textType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("allowMultipleLines", this.getAllowMultipleLines());
        writer.writeBooleanValue("appendChangesToExistingText", this.getAppendChangesToExistingText());
        writer.writeIntegerValue("linesForEditing", this.getLinesForEditing());
        writer.writeIntegerValue("maxLength", this.getMaxLength());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("textType", this.getTextType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAllowMultipleLines(@Nullable Boolean value) {
        this.backingStore.set("allowMultipleLines", (Object)value);
    }

    public void setAppendChangesToExistingText(@Nullable Boolean value) {
        this.backingStore.set("appendChangesToExistingText", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setLinesForEditing(@Nullable Integer value) {
        this.backingStore.set("linesForEditing", (Object)value);
    }

    public void setMaxLength(@Nullable Integer value) {
        this.backingStore.set("maxLength", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setTextType(@Nullable String value) {
        this.backingStore.set("textType", (Object)value);
    }
}

