/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Attachment;
import com.microsoft.graph.models.Attendee;
import com.microsoft.graph.models.Calendar;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.EventType;
import com.microsoft.graph.models.Extension;
import com.microsoft.graph.models.FreeBusyStatus;
import com.microsoft.graph.models.Importance;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.Location;
import com.microsoft.graph.models.MultiValueLegacyExtendedProperty;
import com.microsoft.graph.models.OnlineMeetingInfo;
import com.microsoft.graph.models.OnlineMeetingProviderType;
import com.microsoft.graph.models.OutlookItem;
import com.microsoft.graph.models.PatternedRecurrence;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.ResponseStatus;
import com.microsoft.graph.models.Sensitivity;
import com.microsoft.graph.models.SingleValueLegacyExtendedProperty;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Event
extends OutlookItem
implements Parsable {
    public Event() {
        this.setOdataType("#microsoft.graph.event");
    }

    @Nonnull
    public static Event createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Event();
    }

    @Nullable
    public Boolean getAllowNewTimeProposals() {
        return (Boolean)this.backingStore.get("allowNewTimeProposals");
    }

    @Nullable
    public List<Attachment> getAttachments() {
        return (List)this.backingStore.get("attachments");
    }

    @Nullable
    public List<Attendee> getAttendees() {
        return (List)this.backingStore.get("attendees");
    }

    @Nullable
    public ItemBody getBody() {
        return (ItemBody)this.backingStore.get("body");
    }

    @Nullable
    public String getBodyPreview() {
        return (String)this.backingStore.get("bodyPreview");
    }

    @Nullable
    public Calendar getCalendar() {
        return (Calendar)this.backingStore.get("calendar");
    }

    @Nullable
    public DateTimeTimeZone getEnd() {
        return (DateTimeTimeZone)this.backingStore.get("end");
    }

    @Nullable
    public List<Extension> getExtensions() {
        return (List)this.backingStore.get("extensions");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("allowNewTimeProposals", n -> this.setAllowNewTimeProposals(n.getBooleanValue()));
        deserializerMap.put("attachments", n -> this.setAttachments(n.getCollectionOfObjectValues(Attachment::createFromDiscriminatorValue)));
        deserializerMap.put("attendees", n -> this.setAttendees(n.getCollectionOfObjectValues(Attendee::createFromDiscriminatorValue)));
        deserializerMap.put("body", n -> this.setBody((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("bodyPreview", n -> this.setBodyPreview(n.getStringValue()));
        deserializerMap.put("calendar", n -> this.setCalendar((Calendar)n.getObjectValue(Calendar::createFromDiscriminatorValue)));
        deserializerMap.put("end", n -> this.setEnd((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("extensions", n -> this.setExtensions(n.getCollectionOfObjectValues(Extension::createFromDiscriminatorValue)));
        deserializerMap.put("hasAttachments", n -> this.setHasAttachments(n.getBooleanValue()));
        deserializerMap.put("hideAttendees", n -> this.setHideAttendees(n.getBooleanValue()));
        deserializerMap.put("iCalUId", n -> this.setICalUId(n.getStringValue()));
        deserializerMap.put("importance", n -> this.setImportance((Importance)n.getEnumValue(Importance::forValue)));
        deserializerMap.put("instances", n -> this.setInstances(n.getCollectionOfObjectValues(Event::createFromDiscriminatorValue)));
        deserializerMap.put("isAllDay", n -> this.setIsAllDay(n.getBooleanValue()));
        deserializerMap.put("isCancelled", n -> this.setIsCancelled(n.getBooleanValue()));
        deserializerMap.put("isDraft", n -> this.setIsDraft(n.getBooleanValue()));
        deserializerMap.put("isOnlineMeeting", n -> this.setIsOnlineMeeting(n.getBooleanValue()));
        deserializerMap.put("isOrganizer", n -> this.setIsOrganizer(n.getBooleanValue()));
        deserializerMap.put("isReminderOn", n -> this.setIsReminderOn(n.getBooleanValue()));
        deserializerMap.put("location", n -> this.setLocation((Location)n.getObjectValue(Location::createFromDiscriminatorValue)));
        deserializerMap.put("locations", n -> this.setLocations(n.getCollectionOfObjectValues(Location::createFromDiscriminatorValue)));
        deserializerMap.put("multiValueExtendedProperties", n -> this.setMultiValueExtendedProperties(n.getCollectionOfObjectValues(MultiValueLegacyExtendedProperty::createFromDiscriminatorValue)));
        deserializerMap.put("onlineMeeting", n -> this.setOnlineMeeting((OnlineMeetingInfo)n.getObjectValue(OnlineMeetingInfo::createFromDiscriminatorValue)));
        deserializerMap.put("onlineMeetingProvider", n -> this.setOnlineMeetingProvider((OnlineMeetingProviderType)n.getEnumValue(OnlineMeetingProviderType::forValue)));
        deserializerMap.put("onlineMeetingUrl", n -> this.setOnlineMeetingUrl(n.getStringValue()));
        deserializerMap.put("organizer", n -> this.setOrganizer((Recipient)n.getObjectValue(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("originalEndTimeZone", n -> this.setOriginalEndTimeZone(n.getStringValue()));
        deserializerMap.put("originalStart", n -> this.setOriginalStart(n.getOffsetDateTimeValue()));
        deserializerMap.put("originalStartTimeZone", n -> this.setOriginalStartTimeZone(n.getStringValue()));
        deserializerMap.put("recurrence", n -> this.setRecurrence((PatternedRecurrence)n.getObjectValue(PatternedRecurrence::createFromDiscriminatorValue)));
        deserializerMap.put("reminderMinutesBeforeStart", n -> this.setReminderMinutesBeforeStart(n.getIntegerValue()));
        deserializerMap.put("responseRequested", n -> this.setResponseRequested(n.getBooleanValue()));
        deserializerMap.put("responseStatus", n -> this.setResponseStatus((ResponseStatus)n.getObjectValue(ResponseStatus::createFromDiscriminatorValue)));
        deserializerMap.put("sensitivity", n -> this.setSensitivity((Sensitivity)n.getEnumValue(Sensitivity::forValue)));
        deserializerMap.put("seriesMasterId", n -> this.setSeriesMasterId(n.getStringValue()));
        deserializerMap.put("showAs", n -> this.setShowAs((FreeBusyStatus)n.getEnumValue(FreeBusyStatus::forValue)));
        deserializerMap.put("singleValueExtendedProperties", n -> this.setSingleValueExtendedProperties(n.getCollectionOfObjectValues(SingleValueLegacyExtendedProperty::createFromDiscriminatorValue)));
        deserializerMap.put("start", n -> this.setStart((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("subject", n -> this.setSubject(n.getStringValue()));
        deserializerMap.put("transactionId", n -> this.setTransactionId(n.getStringValue()));
        deserializerMap.put("type", n -> this.setType((EventType)n.getEnumValue(EventType::forValue)));
        deserializerMap.put("webLink", n -> this.setWebLink(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getHasAttachments() {
        return (Boolean)this.backingStore.get("hasAttachments");
    }

    @Nullable
    public Boolean getHideAttendees() {
        return (Boolean)this.backingStore.get("hideAttendees");
    }

    @Nullable
    public String getICalUId() {
        return (String)this.backingStore.get("iCalUId");
    }

    @Nullable
    public Importance getImportance() {
        return (Importance)((Object)this.backingStore.get("importance"));
    }

    @Nullable
    public List<Event> getInstances() {
        return (List)this.backingStore.get("instances");
    }

    @Nullable
    public Boolean getIsAllDay() {
        return (Boolean)this.backingStore.get("isAllDay");
    }

    @Nullable
    public Boolean getIsCancelled() {
        return (Boolean)this.backingStore.get("isCancelled");
    }

    @Nullable
    public Boolean getIsDraft() {
        return (Boolean)this.backingStore.get("isDraft");
    }

    @Nullable
    public Boolean getIsOnlineMeeting() {
        return (Boolean)this.backingStore.get("isOnlineMeeting");
    }

    @Nullable
    public Boolean getIsOrganizer() {
        return (Boolean)this.backingStore.get("isOrganizer");
    }

    @Nullable
    public Boolean getIsReminderOn() {
        return (Boolean)this.backingStore.get("isReminderOn");
    }

    @Nullable
    public Location getLocation() {
        return (Location)this.backingStore.get("location");
    }

    @Nullable
    public List<Location> getLocations() {
        return (List)this.backingStore.get("locations");
    }

    @Nullable
    public List<MultiValueLegacyExtendedProperty> getMultiValueExtendedProperties() {
        return (List)this.backingStore.get("multiValueExtendedProperties");
    }

    @Nullable
    public OnlineMeetingInfo getOnlineMeeting() {
        return (OnlineMeetingInfo)this.backingStore.get("onlineMeeting");
    }

    @Nullable
    public OnlineMeetingProviderType getOnlineMeetingProvider() {
        return (OnlineMeetingProviderType)((Object)this.backingStore.get("onlineMeetingProvider"));
    }

    @Nullable
    public String getOnlineMeetingUrl() {
        return (String)this.backingStore.get("onlineMeetingUrl");
    }

    @Nullable
    public Recipient getOrganizer() {
        return (Recipient)this.backingStore.get("organizer");
    }

    @Nullable
    public String getOriginalEndTimeZone() {
        return (String)this.backingStore.get("originalEndTimeZone");
    }

    @Nullable
    public OffsetDateTime getOriginalStart() {
        return (OffsetDateTime)this.backingStore.get("originalStart");
    }

    @Nullable
    public String getOriginalStartTimeZone() {
        return (String)this.backingStore.get("originalStartTimeZone");
    }

    @Nullable
    public PatternedRecurrence getRecurrence() {
        return (PatternedRecurrence)this.backingStore.get("recurrence");
    }

    @Nullable
    public Integer getReminderMinutesBeforeStart() {
        return (Integer)this.backingStore.get("reminderMinutesBeforeStart");
    }

    @Nullable
    public Boolean getResponseRequested() {
        return (Boolean)this.backingStore.get("responseRequested");
    }

    @Nullable
    public ResponseStatus getResponseStatus() {
        return (ResponseStatus)this.backingStore.get("responseStatus");
    }

    @Nullable
    public Sensitivity getSensitivity() {
        return (Sensitivity)((Object)this.backingStore.get("sensitivity"));
    }

    @Nullable
    public String getSeriesMasterId() {
        return (String)this.backingStore.get("seriesMasterId");
    }

    @Nullable
    public FreeBusyStatus getShowAs() {
        return (FreeBusyStatus)((Object)this.backingStore.get("showAs"));
    }

    @Nullable
    public List<SingleValueLegacyExtendedProperty> getSingleValueExtendedProperties() {
        return (List)this.backingStore.get("singleValueExtendedProperties");
    }

    @Nullable
    public DateTimeTimeZone getStart() {
        return (DateTimeTimeZone)this.backingStore.get("start");
    }

    @Nullable
    public String getSubject() {
        return (String)this.backingStore.get("subject");
    }

    @Nullable
    public String getTransactionId() {
        return (String)this.backingStore.get("transactionId");
    }

    @Nullable
    public EventType getType() {
        return (EventType)((Object)this.backingStore.get("type"));
    }

    @Nullable
    public String getWebLink() {
        return (String)this.backingStore.get("webLink");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeBooleanValue("allowNewTimeProposals", this.getAllowNewTimeProposals());
        writer.writeCollectionOfObjectValues("attachments", this.getAttachments());
        writer.writeCollectionOfObjectValues("attendees", this.getAttendees());
        writer.writeObjectValue("body", (Parsable)this.getBody(), new Parsable[0]);
        writer.writeStringValue("bodyPreview", this.getBodyPreview());
        writer.writeObjectValue("calendar", (Parsable)this.getCalendar(), new Parsable[0]);
        writer.writeObjectValue("end", (Parsable)this.getEnd(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("extensions", this.getExtensions());
        writer.writeBooleanValue("hasAttachments", this.getHasAttachments());
        writer.writeBooleanValue("hideAttendees", this.getHideAttendees());
        writer.writeStringValue("iCalUId", this.getICalUId());
        writer.writeEnumValue("importance", (Enum)this.getImportance());
        writer.writeCollectionOfObjectValues("instances", this.getInstances());
        writer.writeBooleanValue("isAllDay", this.getIsAllDay());
        writer.writeBooleanValue("isCancelled", this.getIsCancelled());
        writer.writeBooleanValue("isDraft", this.getIsDraft());
        writer.writeBooleanValue("isOnlineMeeting", this.getIsOnlineMeeting());
        writer.writeBooleanValue("isOrganizer", this.getIsOrganizer());
        writer.writeBooleanValue("isReminderOn", this.getIsReminderOn());
        writer.writeObjectValue("location", (Parsable)this.getLocation(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("locations", this.getLocations());
        writer.writeCollectionOfObjectValues("multiValueExtendedProperties", this.getMultiValueExtendedProperties());
        writer.writeObjectValue("onlineMeeting", (Parsable)this.getOnlineMeeting(), new Parsable[0]);
        writer.writeEnumValue("onlineMeetingProvider", (Enum)this.getOnlineMeetingProvider());
        writer.writeStringValue("onlineMeetingUrl", this.getOnlineMeetingUrl());
        writer.writeObjectValue("organizer", (Parsable)this.getOrganizer(), new Parsable[0]);
        writer.writeStringValue("originalEndTimeZone", this.getOriginalEndTimeZone());
        writer.writeOffsetDateTimeValue("originalStart", this.getOriginalStart());
        writer.writeStringValue("originalStartTimeZone", this.getOriginalStartTimeZone());
        writer.writeObjectValue("recurrence", (Parsable)this.getRecurrence(), new Parsable[0]);
        writer.writeIntegerValue("reminderMinutesBeforeStart", this.getReminderMinutesBeforeStart());
        writer.writeBooleanValue("responseRequested", this.getResponseRequested());
        writer.writeObjectValue("responseStatus", (Parsable)this.getResponseStatus(), new Parsable[0]);
        writer.writeEnumValue("sensitivity", (Enum)this.getSensitivity());
        writer.writeStringValue("seriesMasterId", this.getSeriesMasterId());
        writer.writeEnumValue("showAs", (Enum)this.getShowAs());
        writer.writeCollectionOfObjectValues("singleValueExtendedProperties", this.getSingleValueExtendedProperties());
        writer.writeObjectValue("start", (Parsable)this.getStart(), new Parsable[0]);
        writer.writeStringValue("subject", this.getSubject());
        writer.writeStringValue("transactionId", this.getTransactionId());
        writer.writeEnumValue("type", (Enum)this.getType());
        writer.writeStringValue("webLink", this.getWebLink());
    }

    public void setAllowNewTimeProposals(@Nullable Boolean value) {
        this.backingStore.set("allowNewTimeProposals", (Object)value);
    }

    public void setAttachments(@Nullable List<Attachment> value) {
        this.backingStore.set("attachments", value);
    }

    public void setAttendees(@Nullable List<Attendee> value) {
        this.backingStore.set("attendees", value);
    }

    public void setBody(@Nullable ItemBody value) {
        this.backingStore.set("body", (Object)value);
    }

    public void setBodyPreview(@Nullable String value) {
        this.backingStore.set("bodyPreview", (Object)value);
    }

    public void setCalendar(@Nullable Calendar value) {
        this.backingStore.set("calendar", (Object)value);
    }

    public void setEnd(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("end", (Object)value);
    }

    public void setExtensions(@Nullable List<Extension> value) {
        this.backingStore.set("extensions", value);
    }

    public void setHasAttachments(@Nullable Boolean value) {
        this.backingStore.set("hasAttachments", (Object)value);
    }

    public void setHideAttendees(@Nullable Boolean value) {
        this.backingStore.set("hideAttendees", (Object)value);
    }

    public void setICalUId(@Nullable String value) {
        this.backingStore.set("iCalUId", (Object)value);
    }

    public void setImportance(@Nullable Importance value) {
        this.backingStore.set("importance", (Object)value);
    }

    public void setInstances(@Nullable List<Event> value) {
        this.backingStore.set("instances", value);
    }

    public void setIsAllDay(@Nullable Boolean value) {
        this.backingStore.set("isAllDay", (Object)value);
    }

    public void setIsCancelled(@Nullable Boolean value) {
        this.backingStore.set("isCancelled", (Object)value);
    }

    public void setIsDraft(@Nullable Boolean value) {
        this.backingStore.set("isDraft", (Object)value);
    }

    public void setIsOnlineMeeting(@Nullable Boolean value) {
        this.backingStore.set("isOnlineMeeting", (Object)value);
    }

    public void setIsOrganizer(@Nullable Boolean value) {
        this.backingStore.set("isOrganizer", (Object)value);
    }

    public void setIsReminderOn(@Nullable Boolean value) {
        this.backingStore.set("isReminderOn", (Object)value);
    }

    public void setLocation(@Nullable Location value) {
        this.backingStore.set("location", (Object)value);
    }

    public void setLocations(@Nullable List<Location> value) {
        this.backingStore.set("locations", value);
    }

    public void setMultiValueExtendedProperties(@Nullable List<MultiValueLegacyExtendedProperty> value) {
        this.backingStore.set("multiValueExtendedProperties", value);
    }

    public void setOnlineMeeting(@Nullable OnlineMeetingInfo value) {
        this.backingStore.set("onlineMeeting", (Object)value);
    }

    public void setOnlineMeetingProvider(@Nullable OnlineMeetingProviderType value) {
        this.backingStore.set("onlineMeetingProvider", (Object)value);
    }

    public void setOnlineMeetingUrl(@Nullable String value) {
        this.backingStore.set("onlineMeetingUrl", (Object)value);
    }

    public void setOrganizer(@Nullable Recipient value) {
        this.backingStore.set("organizer", (Object)value);
    }

    public void setOriginalEndTimeZone(@Nullable String value) {
        this.backingStore.set("originalEndTimeZone", (Object)value);
    }

    public void setOriginalStart(@Nullable OffsetDateTime value) {
        this.backingStore.set("originalStart", (Object)value);
    }

    public void setOriginalStartTimeZone(@Nullable String value) {
        this.backingStore.set("originalStartTimeZone", (Object)value);
    }

    public void setRecurrence(@Nullable PatternedRecurrence value) {
        this.backingStore.set("recurrence", (Object)value);
    }

    public void setReminderMinutesBeforeStart(@Nullable Integer value) {
        this.backingStore.set("reminderMinutesBeforeStart", (Object)value);
    }

    public void setResponseRequested(@Nullable Boolean value) {
        this.backingStore.set("responseRequested", (Object)value);
    }

    public void setResponseStatus(@Nullable ResponseStatus value) {
        this.backingStore.set("responseStatus", (Object)value);
    }

    public void setSensitivity(@Nullable Sensitivity value) {
        this.backingStore.set("sensitivity", (Object)value);
    }

    public void setSeriesMasterId(@Nullable String value) {
        this.backingStore.set("seriesMasterId", (Object)value);
    }

    public void setShowAs(@Nullable FreeBusyStatus value) {
        this.backingStore.set("showAs", (Object)value);
    }

    public void setSingleValueExtendedProperties(@Nullable List<SingleValueLegacyExtendedProperty> value) {
        this.backingStore.set("singleValueExtendedProperties", value);
    }

    public void setStart(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("start", (Object)value);
    }

    public void setSubject(@Nullable String value) {
        this.backingStore.set("subject", (Object)value);
    }

    public void setTransactionId(@Nullable String value) {
        this.backingStore.set("transactionId", (Object)value);
    }

    public void setType(@Nullable EventType value) {
        this.backingStore.set("type", (Object)value);
    }

    public void setWebLink(@Nullable String value) {
        this.backingStore.set("webLink", (Object)value);
    }
}

