/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ChannelIdentity;
import com.microsoft.graph.models.ChatMessageAttachment;
import com.microsoft.graph.models.ChatMessageFromIdentitySet;
import com.microsoft.graph.models.ChatMessageHistoryItem;
import com.microsoft.graph.models.ChatMessageHostedContent;
import com.microsoft.graph.models.ChatMessageImportance;
import com.microsoft.graph.models.ChatMessageMention;
import com.microsoft.graph.models.ChatMessagePolicyViolation;
import com.microsoft.graph.models.ChatMessageReaction;
import com.microsoft.graph.models.ChatMessageType;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.EventMessageDetail;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ChatMessage
extends Entity
implements Parsable {
    @Nonnull
    public static ChatMessage createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ChatMessage();
    }

    @Nullable
    public List<ChatMessageAttachment> getAttachments() {
        return (List)this.backingStore.get("attachments");
    }

    @Nullable
    public ItemBody getBody() {
        return (ItemBody)this.backingStore.get("body");
    }

    @Nullable
    public ChannelIdentity getChannelIdentity() {
        return (ChannelIdentity)this.backingStore.get("channelIdentity");
    }

    @Nullable
    public String getChatId() {
        return (String)this.backingStore.get("chatId");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public OffsetDateTime getDeletedDateTime() {
        return (OffsetDateTime)this.backingStore.get("deletedDateTime");
    }

    @Nullable
    public String getEtag() {
        return (String)this.backingStore.get("etag");
    }

    @Nullable
    public EventMessageDetail getEventDetail() {
        return (EventMessageDetail)this.backingStore.get("eventDetail");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("attachments", n -> this.setAttachments(n.getCollectionOfObjectValues(ChatMessageAttachment::createFromDiscriminatorValue)));
        deserializerMap.put("body", n -> this.setBody((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("channelIdentity", n -> this.setChannelIdentity((ChannelIdentity)n.getObjectValue(ChannelIdentity::createFromDiscriminatorValue)));
        deserializerMap.put("chatId", n -> this.setChatId(n.getStringValue()));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("deletedDateTime", n -> this.setDeletedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("etag", n -> this.setEtag(n.getStringValue()));
        deserializerMap.put("eventDetail", n -> this.setEventDetail((EventMessageDetail)n.getObjectValue(EventMessageDetail::createFromDiscriminatorValue)));
        deserializerMap.put("from", n -> this.setFrom((ChatMessageFromIdentitySet)n.getObjectValue(ChatMessageFromIdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("hostedContents", n -> this.setHostedContents(n.getCollectionOfObjectValues(ChatMessageHostedContent::createFromDiscriminatorValue)));
        deserializerMap.put("importance", n -> this.setImportance((ChatMessageImportance)n.getEnumValue(ChatMessageImportance::forValue)));
        deserializerMap.put("lastEditedDateTime", n -> this.setLastEditedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("locale", n -> this.setLocale(n.getStringValue()));
        deserializerMap.put("mentions", n -> this.setMentions(n.getCollectionOfObjectValues(ChatMessageMention::createFromDiscriminatorValue)));
        deserializerMap.put("messageHistory", n -> this.setMessageHistory(n.getCollectionOfObjectValues(ChatMessageHistoryItem::createFromDiscriminatorValue)));
        deserializerMap.put("messageType", n -> this.setMessageType((ChatMessageType)n.getEnumValue(ChatMessageType::forValue)));
        deserializerMap.put("policyViolation", n -> this.setPolicyViolation((ChatMessagePolicyViolation)n.getObjectValue(ChatMessagePolicyViolation::createFromDiscriminatorValue)));
        deserializerMap.put("reactions", n -> this.setReactions(n.getCollectionOfObjectValues(ChatMessageReaction::createFromDiscriminatorValue)));
        deserializerMap.put("replies", n -> this.setReplies(n.getCollectionOfObjectValues(ChatMessage::createFromDiscriminatorValue)));
        deserializerMap.put("replyToId", n -> this.setReplyToId(n.getStringValue()));
        deserializerMap.put("subject", n -> this.setSubject(n.getStringValue()));
        deserializerMap.put("summary", n -> this.setSummary(n.getStringValue()));
        deserializerMap.put("webUrl", n -> this.setWebUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public ChatMessageFromIdentitySet getFrom() {
        return (ChatMessageFromIdentitySet)this.backingStore.get("from");
    }

    @Nullable
    public List<ChatMessageHostedContent> getHostedContents() {
        return (List)this.backingStore.get("hostedContents");
    }

    @Nullable
    public ChatMessageImportance getImportance() {
        return (ChatMessageImportance)((Object)this.backingStore.get("importance"));
    }

    @Nullable
    public OffsetDateTime getLastEditedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastEditedDateTime");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public String getLocale() {
        return (String)this.backingStore.get("locale");
    }

    @Nullable
    public List<ChatMessageMention> getMentions() {
        return (List)this.backingStore.get("mentions");
    }

    @Nullable
    public List<ChatMessageHistoryItem> getMessageHistory() {
        return (List)this.backingStore.get("messageHistory");
    }

    @Nullable
    public ChatMessageType getMessageType() {
        return (ChatMessageType)((Object)this.backingStore.get("messageType"));
    }

    @Nullable
    public ChatMessagePolicyViolation getPolicyViolation() {
        return (ChatMessagePolicyViolation)this.backingStore.get("policyViolation");
    }

    @Nullable
    public List<ChatMessageReaction> getReactions() {
        return (List)this.backingStore.get("reactions");
    }

    @Nullable
    public List<ChatMessage> getReplies() {
        return (List)this.backingStore.get("replies");
    }

    @Nullable
    public String getReplyToId() {
        return (String)this.backingStore.get("replyToId");
    }

    @Nullable
    public String getSubject() {
        return (String)this.backingStore.get("subject");
    }

    @Nullable
    public String getSummary() {
        return (String)this.backingStore.get("summary");
    }

    @Nullable
    public String getWebUrl() {
        return (String)this.backingStore.get("webUrl");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("attachments", this.getAttachments());
        writer.writeObjectValue("body", (Parsable)this.getBody(), new Parsable[0]);
        writer.writeObjectValue("channelIdentity", (Parsable)this.getChannelIdentity(), new Parsable[0]);
        writer.writeStringValue("chatId", this.getChatId());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeOffsetDateTimeValue("deletedDateTime", this.getDeletedDateTime());
        writer.writeStringValue("etag", this.getEtag());
        writer.writeObjectValue("eventDetail", (Parsable)this.getEventDetail(), new Parsable[0]);
        writer.writeObjectValue("from", (Parsable)this.getFrom(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("hostedContents", this.getHostedContents());
        writer.writeEnumValue("importance", (Enum)this.getImportance());
        writer.writeOffsetDateTimeValue("lastEditedDateTime", this.getLastEditedDateTime());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeStringValue("locale", this.getLocale());
        writer.writeCollectionOfObjectValues("mentions", this.getMentions());
        writer.writeCollectionOfObjectValues("messageHistory", this.getMessageHistory());
        writer.writeEnumValue("messageType", (Enum)this.getMessageType());
        writer.writeObjectValue("policyViolation", (Parsable)this.getPolicyViolation(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("reactions", this.getReactions());
        writer.writeCollectionOfObjectValues("replies", this.getReplies());
        writer.writeStringValue("replyToId", this.getReplyToId());
        writer.writeStringValue("subject", this.getSubject());
        writer.writeStringValue("summary", this.getSummary());
        writer.writeStringValue("webUrl", this.getWebUrl());
    }

    public void setAttachments(@Nullable List<ChatMessageAttachment> value) {
        this.backingStore.set("attachments", value);
    }

    public void setBody(@Nullable ItemBody value) {
        this.backingStore.set("body", (Object)value);
    }

    public void setChannelIdentity(@Nullable ChannelIdentity value) {
        this.backingStore.set("channelIdentity", (Object)value);
    }

    public void setChatId(@Nullable String value) {
        this.backingStore.set("chatId", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDeletedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("deletedDateTime", (Object)value);
    }

    public void setEtag(@Nullable String value) {
        this.backingStore.set("etag", (Object)value);
    }

    public void setEventDetail(@Nullable EventMessageDetail value) {
        this.backingStore.set("eventDetail", (Object)value);
    }

    public void setFrom(@Nullable ChatMessageFromIdentitySet value) {
        this.backingStore.set("from", (Object)value);
    }

    public void setHostedContents(@Nullable List<ChatMessageHostedContent> value) {
        this.backingStore.set("hostedContents", value);
    }

    public void setImportance(@Nullable ChatMessageImportance value) {
        this.backingStore.set("importance", (Object)value);
    }

    public void setLastEditedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastEditedDateTime", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setLocale(@Nullable String value) {
        this.backingStore.set("locale", (Object)value);
    }

    public void setMentions(@Nullable List<ChatMessageMention> value) {
        this.backingStore.set("mentions", value);
    }

    public void setMessageHistory(@Nullable List<ChatMessageHistoryItem> value) {
        this.backingStore.set("messageHistory", value);
    }

    public void setMessageType(@Nullable ChatMessageType value) {
        this.backingStore.set("messageType", (Object)value);
    }

    public void setPolicyViolation(@Nullable ChatMessagePolicyViolation value) {
        this.backingStore.set("policyViolation", (Object)value);
    }

    public void setReactions(@Nullable List<ChatMessageReaction> value) {
        this.backingStore.set("reactions", value);
    }

    public void setReplies(@Nullable List<ChatMessage> value) {
        this.backingStore.set("replies", value);
    }

    public void setReplyToId(@Nullable String value) {
        this.backingStore.set("replyToId", (Object)value);
    }

    public void setSubject(@Nullable String value) {
        this.backingStore.set("subject", (Object)value);
    }

    public void setSummary(@Nullable String value) {
        this.backingStore.set("summary", (Object)value);
    }

    public void setWebUrl(@Nullable String value) {
        this.backingStore.set("webUrl", (Object)value);
    }
}

