/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.SharedPCAccountDeletionPolicyType;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SharedPCAccountManagerPolicy
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SharedPCAccountManagerPolicy() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SharedPCAccountManagerPolicy createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SharedPCAccountManagerPolicy();
    }

    @Nullable
    public SharedPCAccountDeletionPolicyType getAccountDeletionPolicy() {
        return (SharedPCAccountDeletionPolicyType)((Object)this.backingStore.get("accountDeletionPolicy"));
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Integer getCacheAccountsAboveDiskFreePercentage() {
        return (Integer)this.backingStore.get("cacheAccountsAboveDiskFreePercentage");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("accountDeletionPolicy", n -> this.setAccountDeletionPolicy((SharedPCAccountDeletionPolicyType)n.getEnumValue(SharedPCAccountDeletionPolicyType::forValue)));
        deserializerMap.put("cacheAccountsAboveDiskFreePercentage", n -> this.setCacheAccountsAboveDiskFreePercentage(n.getIntegerValue()));
        deserializerMap.put("inactiveThresholdDays", n -> this.setInactiveThresholdDays(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("removeAccountsBelowDiskFreePercentage", n -> this.setRemoveAccountsBelowDiskFreePercentage(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public Integer getInactiveThresholdDays() {
        return (Integer)this.backingStore.get("inactiveThresholdDays");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Integer getRemoveAccountsBelowDiskFreePercentage() {
        return (Integer)this.backingStore.get("removeAccountsBelowDiskFreePercentage");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumValue("accountDeletionPolicy", (Enum)this.getAccountDeletionPolicy());
        writer.writeIntegerValue("cacheAccountsAboveDiskFreePercentage", this.getCacheAccountsAboveDiskFreePercentage());
        writer.writeIntegerValue("inactiveThresholdDays", this.getInactiveThresholdDays());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeIntegerValue("removeAccountsBelowDiskFreePercentage", this.getRemoveAccountsBelowDiskFreePercentage());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAccountDeletionPolicy(@Nullable SharedPCAccountDeletionPolicyType value) {
        this.backingStore.set("accountDeletionPolicy", (Object)value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCacheAccountsAboveDiskFreePercentage(@Nullable Integer value) {
        this.backingStore.set("cacheAccountsAboveDiskFreePercentage", (Object)value);
    }

    public void setInactiveThresholdDays(@Nullable Integer value) {
        this.backingStore.set("inactiveThresholdDays", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRemoveAccountsBelowDiskFreePercentage(@Nullable Integer value) {
        this.backingStore.set("removeAccountsBelowDiskFreePercentage", (Object)value);
    }
}

