/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ActivityMetadata;
import com.microsoft.graph.models.DeviceMetadata;
import com.microsoft.graph.models.IntegratedApplicationMetadata;
import com.microsoft.graph.models.ProcessContentMetadataBase;
import com.microsoft.graph.models.ProtectedApplicationMetadata;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ProcessContentRequest
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ProcessContentRequest() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ProcessContentRequest createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ProcessContentRequest();
    }

    @Nullable
    public ActivityMetadata getActivityMetadata() {
        return (ActivityMetadata)this.backingStore.get("activityMetadata");
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<ProcessContentMetadataBase> getContentEntries() {
        return (List)this.backingStore.get("contentEntries");
    }

    @Nullable
    public DeviceMetadata getDeviceMetadata() {
        return (DeviceMetadata)this.backingStore.get("deviceMetadata");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("activityMetadata", n -> this.setActivityMetadata((ActivityMetadata)n.getObjectValue(ActivityMetadata::createFromDiscriminatorValue)));
        deserializerMap.put("contentEntries", n -> this.setContentEntries(n.getCollectionOfObjectValues(ProcessContentMetadataBase::createFromDiscriminatorValue)));
        deserializerMap.put("deviceMetadata", n -> this.setDeviceMetadata((DeviceMetadata)n.getObjectValue(DeviceMetadata::createFromDiscriminatorValue)));
        deserializerMap.put("integratedAppMetadata", n -> this.setIntegratedAppMetadata((IntegratedApplicationMetadata)n.getObjectValue(IntegratedApplicationMetadata::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("protectedAppMetadata", n -> this.setProtectedAppMetadata((ProtectedApplicationMetadata)n.getObjectValue(ProtectedApplicationMetadata::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public IntegratedApplicationMetadata getIntegratedAppMetadata() {
        return (IntegratedApplicationMetadata)this.backingStore.get("integratedAppMetadata");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public ProtectedApplicationMetadata getProtectedAppMetadata() {
        return (ProtectedApplicationMetadata)this.backingStore.get("protectedAppMetadata");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("activityMetadata", (Parsable)this.getActivityMetadata(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("contentEntries", this.getContentEntries());
        writer.writeObjectValue("deviceMetadata", (Parsable)this.getDeviceMetadata(), new Parsable[0]);
        writer.writeObjectValue("integratedAppMetadata", (Parsable)this.getIntegratedAppMetadata(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("protectedAppMetadata", (Parsable)this.getProtectedAppMetadata(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setActivityMetadata(@Nullable ActivityMetadata value) {
        this.backingStore.set("activityMetadata", (Object)value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setContentEntries(@Nullable List<ProcessContentMetadataBase> value) {
        this.backingStore.set("contentEntries", value);
    }

    public void setDeviceMetadata(@Nullable DeviceMetadata value) {
        this.backingStore.set("deviceMetadata", (Object)value);
    }

    public void setIntegratedAppMetadata(@Nullable IntegratedApplicationMetadata value) {
        this.backingStore.set("integratedAppMetadata", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setProtectedAppMetadata(@Nullable ProtectedApplicationMetadata value) {
        this.backingStore.set("protectedAppMetadata", (Object)value);
    }
}

