/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.DomainDnsRecord;
import com.microsoft.graph.models.DomainState;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.InternalDomainFederation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Domain
extends Entity
implements Parsable {
    @Nonnull
    public static Domain createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Domain();
    }

    @Nullable
    public String getAuthenticationType() {
        return (String)this.backingStore.get("authenticationType");
    }

    @Nullable
    public String getAvailabilityStatus() {
        return (String)this.backingStore.get("availabilityStatus");
    }

    @Nullable
    public List<DirectoryObject> getDomainNameReferences() {
        return (List)this.backingStore.get("domainNameReferences");
    }

    @Nullable
    public List<InternalDomainFederation> getFederationConfiguration() {
        return (List)this.backingStore.get("federationConfiguration");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("authenticationType", n -> this.setAuthenticationType(n.getStringValue()));
        deserializerMap.put("availabilityStatus", n -> this.setAvailabilityStatus(n.getStringValue()));
        deserializerMap.put("domainNameReferences", n -> this.setDomainNameReferences(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("federationConfiguration", n -> this.setFederationConfiguration(n.getCollectionOfObjectValues(InternalDomainFederation::createFromDiscriminatorValue)));
        deserializerMap.put("isAdminManaged", n -> this.setIsAdminManaged(n.getBooleanValue()));
        deserializerMap.put("isDefault", n -> this.setIsDefault(n.getBooleanValue()));
        deserializerMap.put("isInitial", n -> this.setIsInitial(n.getBooleanValue()));
        deserializerMap.put("isRoot", n -> this.setIsRoot(n.getBooleanValue()));
        deserializerMap.put("isVerified", n -> this.setIsVerified(n.getBooleanValue()));
        deserializerMap.put("manufacturer", n -> this.setManufacturer(n.getStringValue()));
        deserializerMap.put("model", n -> this.setModel(n.getStringValue()));
        deserializerMap.put("passwordNotificationWindowInDays", n -> this.setPasswordNotificationWindowInDays(n.getIntegerValue()));
        deserializerMap.put("passwordValidityPeriodInDays", n -> this.setPasswordValidityPeriodInDays(n.getIntegerValue()));
        deserializerMap.put("rootDomain", n -> this.setRootDomain((Domain)n.getObjectValue(Domain::createFromDiscriminatorValue)));
        deserializerMap.put("serviceConfigurationRecords", n -> this.setServiceConfigurationRecords(n.getCollectionOfObjectValues(DomainDnsRecord::createFromDiscriminatorValue)));
        deserializerMap.put("state", n -> this.setState((DomainState)n.getObjectValue(DomainState::createFromDiscriminatorValue)));
        deserializerMap.put("supportedServices", n -> this.setSupportedServices(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("verificationDnsRecords", n -> this.setVerificationDnsRecords(n.getCollectionOfObjectValues(DomainDnsRecord::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsAdminManaged() {
        return (Boolean)this.backingStore.get("isAdminManaged");
    }

    @Nullable
    public Boolean getIsDefault() {
        return (Boolean)this.backingStore.get("isDefault");
    }

    @Nullable
    public Boolean getIsInitial() {
        return (Boolean)this.backingStore.get("isInitial");
    }

    @Nullable
    public Boolean getIsRoot() {
        return (Boolean)this.backingStore.get("isRoot");
    }

    @Nullable
    public Boolean getIsVerified() {
        return (Boolean)this.backingStore.get("isVerified");
    }

    @Nullable
    public String getManufacturer() {
        return (String)this.backingStore.get("manufacturer");
    }

    @Nullable
    public String getModel() {
        return (String)this.backingStore.get("model");
    }

    @Nullable
    public Integer getPasswordNotificationWindowInDays() {
        return (Integer)this.backingStore.get("passwordNotificationWindowInDays");
    }

    @Nullable
    public Integer getPasswordValidityPeriodInDays() {
        return (Integer)this.backingStore.get("passwordValidityPeriodInDays");
    }

    @Nullable
    public Domain getRootDomain() {
        return (Domain)this.backingStore.get("rootDomain");
    }

    @Nullable
    public List<DomainDnsRecord> getServiceConfigurationRecords() {
        return (List)this.backingStore.get("serviceConfigurationRecords");
    }

    @Nullable
    public DomainState getState() {
        return (DomainState)this.backingStore.get("state");
    }

    @Nullable
    public List<String> getSupportedServices() {
        return (List)this.backingStore.get("supportedServices");
    }

    @Nullable
    public List<DomainDnsRecord> getVerificationDnsRecords() {
        return (List)this.backingStore.get("verificationDnsRecords");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("authenticationType", this.getAuthenticationType());
        writer.writeStringValue("availabilityStatus", this.getAvailabilityStatus());
        writer.writeCollectionOfObjectValues("domainNameReferences", this.getDomainNameReferences());
        writer.writeCollectionOfObjectValues("federationConfiguration", this.getFederationConfiguration());
        writer.writeBooleanValue("isAdminManaged", this.getIsAdminManaged());
        writer.writeBooleanValue("isDefault", this.getIsDefault());
        writer.writeBooleanValue("isInitial", this.getIsInitial());
        writer.writeBooleanValue("isRoot", this.getIsRoot());
        writer.writeBooleanValue("isVerified", this.getIsVerified());
        writer.writeStringValue("manufacturer", this.getManufacturer());
        writer.writeStringValue("model", this.getModel());
        writer.writeIntegerValue("passwordNotificationWindowInDays", this.getPasswordNotificationWindowInDays());
        writer.writeIntegerValue("passwordValidityPeriodInDays", this.getPasswordValidityPeriodInDays());
        writer.writeObjectValue("rootDomain", (Parsable)this.getRootDomain(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("serviceConfigurationRecords", this.getServiceConfigurationRecords());
        writer.writeObjectValue("state", (Parsable)this.getState(), new Parsable[0]);
        writer.writeCollectionOfPrimitiveValues("supportedServices", this.getSupportedServices());
        writer.writeCollectionOfObjectValues("verificationDnsRecords", this.getVerificationDnsRecords());
    }

    public void setAuthenticationType(@Nullable String value) {
        this.backingStore.set("authenticationType", (Object)value);
    }

    public void setAvailabilityStatus(@Nullable String value) {
        this.backingStore.set("availabilityStatus", (Object)value);
    }

    public void setDomainNameReferences(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("domainNameReferences", value);
    }

    public void setFederationConfiguration(@Nullable List<InternalDomainFederation> value) {
        this.backingStore.set("federationConfiguration", value);
    }

    public void setIsAdminManaged(@Nullable Boolean value) {
        this.backingStore.set("isAdminManaged", (Object)value);
    }

    public void setIsDefault(@Nullable Boolean value) {
        this.backingStore.set("isDefault", (Object)value);
    }

    public void setIsInitial(@Nullable Boolean value) {
        this.backingStore.set("isInitial", (Object)value);
    }

    public void setIsRoot(@Nullable Boolean value) {
        this.backingStore.set("isRoot", (Object)value);
    }

    public void setIsVerified(@Nullable Boolean value) {
        this.backingStore.set("isVerified", (Object)value);
    }

    public void setManufacturer(@Nullable String value) {
        this.backingStore.set("manufacturer", (Object)value);
    }

    public void setModel(@Nullable String value) {
        this.backingStore.set("model", (Object)value);
    }

    public void setPasswordNotificationWindowInDays(@Nullable Integer value) {
        this.backingStore.set("passwordNotificationWindowInDays", (Object)value);
    }

    public void setPasswordValidityPeriodInDays(@Nullable Integer value) {
        this.backingStore.set("passwordValidityPeriodInDays", (Object)value);
    }

    public void setRootDomain(@Nullable Domain value) {
        this.backingStore.set("rootDomain", (Object)value);
    }

    public void setServiceConfigurationRecords(@Nullable List<DomainDnsRecord> value) {
        this.backingStore.set("serviceConfigurationRecords", value);
    }

    public void setState(@Nullable DomainState value) {
        this.backingStore.set("state", (Object)value);
    }

    public void setSupportedServices(@Nullable List<String> value) {
        this.backingStore.set("supportedServices", value);
    }

    public void setVerificationDnsRecords(@Nullable List<DomainDnsRecord> value) {
        this.backingStore.set("verificationDnsRecords", value);
    }
}

