/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DefaultUserRolePermissions
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public DefaultUserRolePermissions() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static DefaultUserRolePermissions createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DefaultUserRolePermissions();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public Boolean getAllowedToCreateApps() {
        return (Boolean)this.backingStore.get("allowedToCreateApps");
    }

    @Nullable
    public Boolean getAllowedToCreateSecurityGroups() {
        return (Boolean)this.backingStore.get("allowedToCreateSecurityGroups");
    }

    @Nullable
    public Boolean getAllowedToCreateTenants() {
        return (Boolean)this.backingStore.get("allowedToCreateTenants");
    }

    @Nullable
    public Boolean getAllowedToReadBitlockerKeysForOwnedDevice() {
        return (Boolean)this.backingStore.get("allowedToReadBitlockerKeysForOwnedDevice");
    }

    @Nullable
    public Boolean getAllowedToReadOtherUsers() {
        return (Boolean)this.backingStore.get("allowedToReadOtherUsers");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("allowedToCreateApps", n -> this.setAllowedToCreateApps(n.getBooleanValue()));
        deserializerMap.put("allowedToCreateSecurityGroups", n -> this.setAllowedToCreateSecurityGroups(n.getBooleanValue()));
        deserializerMap.put("allowedToCreateTenants", n -> this.setAllowedToCreateTenants(n.getBooleanValue()));
        deserializerMap.put("allowedToReadBitlockerKeysForOwnedDevice", n -> this.setAllowedToReadBitlockerKeysForOwnedDevice(n.getBooleanValue()));
        deserializerMap.put("allowedToReadOtherUsers", n -> this.setAllowedToReadOtherUsers(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("permissionGrantPoliciesAssigned", n -> this.setPermissionGrantPoliciesAssigned(n.getCollectionOfPrimitiveValues(String.class)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<String> getPermissionGrantPoliciesAssigned() {
        return (List)this.backingStore.get("permissionGrantPoliciesAssigned");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("allowedToCreateApps", this.getAllowedToCreateApps());
        writer.writeBooleanValue("allowedToCreateSecurityGroups", this.getAllowedToCreateSecurityGroups());
        writer.writeBooleanValue("allowedToCreateTenants", this.getAllowedToCreateTenants());
        writer.writeBooleanValue("allowedToReadBitlockerKeysForOwnedDevice", this.getAllowedToReadBitlockerKeysForOwnedDevice());
        writer.writeBooleanValue("allowedToReadOtherUsers", this.getAllowedToReadOtherUsers());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfPrimitiveValues("permissionGrantPoliciesAssigned", this.getPermissionGrantPoliciesAssigned());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAllowedToCreateApps(@Nullable Boolean value) {
        this.backingStore.set("allowedToCreateApps", (Object)value);
    }

    public void setAllowedToCreateSecurityGroups(@Nullable Boolean value) {
        this.backingStore.set("allowedToCreateSecurityGroups", (Object)value);
    }

    public void setAllowedToCreateTenants(@Nullable Boolean value) {
        this.backingStore.set("allowedToCreateTenants", (Object)value);
    }

    public void setAllowedToReadBitlockerKeysForOwnedDevice(@Nullable Boolean value) {
        this.backingStore.set("allowedToReadBitlockerKeysForOwnedDevice", (Object)value);
    }

    public void setAllowedToReadOtherUsers(@Nullable Boolean value) {
        this.backingStore.set("allowedToReadOtherUsers", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPermissionGrantPoliciesAssigned(@Nullable List<String> value) {
        this.backingStore.set("permissionGrantPoliciesAssigned", value);
    }
}

