/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationStrengthPolicy;
import com.microsoft.graph.models.ConditionalAccessGrantControl;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ConditionalAccessGrantControls
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ConditionalAccessGrantControls() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ConditionalAccessGrantControls createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ConditionalAccessGrantControls();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public AuthenticationStrengthPolicy getAuthenticationStrength() {
        return (AuthenticationStrengthPolicy)this.backingStore.get("authenticationStrength");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<ConditionalAccessGrantControl> getBuiltInControls() {
        return (List)this.backingStore.get("builtInControls");
    }

    @Nullable
    public List<String> getCustomAuthenticationFactors() {
        return (List)this.backingStore.get("customAuthenticationFactors");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("authenticationStrength", n -> this.setAuthenticationStrength((AuthenticationStrengthPolicy)n.getObjectValue(AuthenticationStrengthPolicy::createFromDiscriminatorValue)));
        deserializerMap.put("builtInControls", n -> this.setBuiltInControls(n.getCollectionOfEnumValues(ConditionalAccessGrantControl::forValue)));
        deserializerMap.put("customAuthenticationFactors", n -> this.setCustomAuthenticationFactors(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("operator", n -> this.setOperator(n.getStringValue()));
        deserializerMap.put("termsOfUse", n -> this.setTermsOfUse(n.getCollectionOfPrimitiveValues(String.class)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getOperator() {
        return (String)this.backingStore.get("operator");
    }

    @Nullable
    public List<String> getTermsOfUse() {
        return (List)this.backingStore.get("termsOfUse");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("authenticationStrength", (Parsable)this.getAuthenticationStrength(), new Parsable[0]);
        writer.writeCollectionOfEnumValues("builtInControls", this.getBuiltInControls());
        writer.writeCollectionOfPrimitiveValues("customAuthenticationFactors", this.getCustomAuthenticationFactors());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("operator", this.getOperator());
        writer.writeCollectionOfPrimitiveValues("termsOfUse", this.getTermsOfUse());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAuthenticationStrength(@Nullable AuthenticationStrengthPolicy value) {
        this.backingStore.set("authenticationStrength", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBuiltInControls(@Nullable List<ConditionalAccessGrantControl> value) {
        this.backingStore.set("builtInControls", value);
    }

    public void setCustomAuthenticationFactors(@Nullable List<String> value) {
        this.backingStore.set("customAuthenticationFactors", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOperator(@Nullable String value) {
        this.backingStore.set("operator", (Object)value);
    }

    public void setTermsOfUse(@Nullable List<String> value) {
        this.backingStore.set("termsOfUse", value);
    }
}

