/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ChannelMembershipType;
import com.microsoft.graph.models.ChannelSummary;
import com.microsoft.graph.models.ChatMessage;
import com.microsoft.graph.models.ConversationMember;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.SharedWithChannelTeamInfo;
import com.microsoft.graph.models.TeamsTab;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Channel
extends Entity
implements Parsable {
    @Nonnull
    public static Channel createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Channel();
    }

    @Nullable
    public List<ConversationMember> getAllMembers() {
        return (List)this.backingStore.get("allMembers");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public String getEmail() {
        return (String)this.backingStore.get("email");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("allMembers", n -> this.setAllMembers(n.getCollectionOfObjectValues(ConversationMember::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("email", n -> this.setEmail(n.getStringValue()));
        deserializerMap.put("filesFolder", n -> this.setFilesFolder((DriveItem)n.getObjectValue(DriveItem::createFromDiscriminatorValue)));
        deserializerMap.put("isArchived", n -> this.setIsArchived(n.getBooleanValue()));
        deserializerMap.put("isFavoriteByDefault", n -> this.setIsFavoriteByDefault(n.getBooleanValue()));
        deserializerMap.put("members", n -> this.setMembers(n.getCollectionOfObjectValues(ConversationMember::createFromDiscriminatorValue)));
        deserializerMap.put("membershipType", n -> this.setMembershipType((ChannelMembershipType)n.getEnumValue(ChannelMembershipType::forValue)));
        deserializerMap.put("messages", n -> this.setMessages(n.getCollectionOfObjectValues(ChatMessage::createFromDiscriminatorValue)));
        deserializerMap.put("sharedWithTeams", n -> this.setSharedWithTeams(n.getCollectionOfObjectValues(SharedWithChannelTeamInfo::createFromDiscriminatorValue)));
        deserializerMap.put("summary", n -> this.setSummary((ChannelSummary)n.getObjectValue(ChannelSummary::createFromDiscriminatorValue)));
        deserializerMap.put("tabs", n -> this.setTabs(n.getCollectionOfObjectValues(TeamsTab::createFromDiscriminatorValue)));
        deserializerMap.put("tenantId", n -> this.setTenantId(n.getStringValue()));
        deserializerMap.put("webUrl", n -> this.setWebUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public DriveItem getFilesFolder() {
        return (DriveItem)this.backingStore.get("filesFolder");
    }

    @Nullable
    public Boolean getIsArchived() {
        return (Boolean)this.backingStore.get("isArchived");
    }

    @Nullable
    public Boolean getIsFavoriteByDefault() {
        return (Boolean)this.backingStore.get("isFavoriteByDefault");
    }

    @Nullable
    public List<ConversationMember> getMembers() {
        return (List)this.backingStore.get("members");
    }

    @Nullable
    public ChannelMembershipType getMembershipType() {
        return (ChannelMembershipType)((Object)this.backingStore.get("membershipType"));
    }

    @Nullable
    public List<ChatMessage> getMessages() {
        return (List)this.backingStore.get("messages");
    }

    @Nullable
    public List<SharedWithChannelTeamInfo> getSharedWithTeams() {
        return (List)this.backingStore.get("sharedWithTeams");
    }

    @Nullable
    public ChannelSummary getSummary() {
        return (ChannelSummary)this.backingStore.get("summary");
    }

    @Nullable
    public List<TeamsTab> getTabs() {
        return (List)this.backingStore.get("tabs");
    }

    @Nullable
    public String getTenantId() {
        return (String)this.backingStore.get("tenantId");
    }

    @Nullable
    public String getWebUrl() {
        return (String)this.backingStore.get("webUrl");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("allMembers", this.getAllMembers());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("email", this.getEmail());
        writer.writeObjectValue("filesFolder", (Parsable)this.getFilesFolder(), new Parsable[0]);
        writer.writeBooleanValue("isArchived", this.getIsArchived());
        writer.writeBooleanValue("isFavoriteByDefault", this.getIsFavoriteByDefault());
        writer.writeCollectionOfObjectValues("members", this.getMembers());
        writer.writeEnumValue("membershipType", (Enum)this.getMembershipType());
        writer.writeCollectionOfObjectValues("messages", this.getMessages());
        writer.writeCollectionOfObjectValues("sharedWithTeams", this.getSharedWithTeams());
        writer.writeObjectValue("summary", (Parsable)this.getSummary(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("tabs", this.getTabs());
        writer.writeStringValue("tenantId", this.getTenantId());
        writer.writeStringValue("webUrl", this.getWebUrl());
    }

    public void setAllMembers(@Nullable List<ConversationMember> value) {
        this.backingStore.set("allMembers", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setEmail(@Nullable String value) {
        this.backingStore.set("email", (Object)value);
    }

    public void setFilesFolder(@Nullable DriveItem value) {
        this.backingStore.set("filesFolder", (Object)value);
    }

    public void setIsArchived(@Nullable Boolean value) {
        this.backingStore.set("isArchived", (Object)value);
    }

    public void setIsFavoriteByDefault(@Nullable Boolean value) {
        this.backingStore.set("isFavoriteByDefault", (Object)value);
    }

    public void setMembers(@Nullable List<ConversationMember> value) {
        this.backingStore.set("members", value);
    }

    public void setMembershipType(@Nullable ChannelMembershipType value) {
        this.backingStore.set("membershipType", (Object)value);
    }

    public void setMessages(@Nullable List<ChatMessage> value) {
        this.backingStore.set("messages", value);
    }

    public void setSharedWithTeams(@Nullable List<SharedWithChannelTeamInfo> value) {
        this.backingStore.set("sharedWithTeams", value);
    }

    public void setSummary(@Nullable ChannelSummary value) {
        this.backingStore.set("summary", (Object)value);
    }

    public void setTabs(@Nullable List<TeamsTab> value) {
        this.backingStore.set("tabs", value);
    }

    public void setTenantId(@Nullable String value) {
        this.backingStore.set("tenantId", (Object)value);
    }

    public void setWebUrl(@Nullable String value) {
        this.backingStore.set("webUrl", (Object)value);
    }
}

