/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.CallEventType;
import com.microsoft.graph.models.EmergencyCallEvent;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.Participant;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class CallEvent
extends Entity
implements Parsable {
    @Nonnull
    public static CallEvent createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.emergencyCallEvent": {
                    return new EmergencyCallEvent();
                }
            }
        }
        return new CallEvent();
    }

    @Nullable
    public CallEventType getCallEventType() {
        return (CallEventType)((Object)this.backingStore.get("callEventType"));
    }

    @Nullable
    public OffsetDateTime getEventDateTime() {
        return (OffsetDateTime)this.backingStore.get("eventDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("callEventType", n -> this.setCallEventType((CallEventType)n.getEnumValue(CallEventType::forValue)));
        deserializerMap.put("eventDateTime", n -> this.setEventDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("participants", n -> this.setParticipants(n.getCollectionOfObjectValues(Participant::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<Participant> getParticipants() {
        return (List)this.backingStore.get("participants");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeEnumValue("callEventType", (Enum)this.getCallEventType());
        writer.writeOffsetDateTimeValue("eventDateTime", this.getEventDateTime());
        writer.writeCollectionOfObjectValues("participants", this.getParticipants());
    }

    public void setCallEventType(@Nullable CallEventType value) {
        this.backingStore.set("callEventType", (Object)value);
    }

    public void setEventDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("eventDateTime", (Object)value);
    }

    public void setParticipants(@Nullable List<Participant> value) {
        this.backingStore.set("participants", value);
    }
}

