/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationMethodState;
import com.microsoft.graph.models.EmailAuthenticationMethodConfiguration;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.ExcludeTarget;
import com.microsoft.graph.models.Fido2AuthenticationMethodConfiguration;
import com.microsoft.graph.models.MicrosoftAuthenticatorAuthenticationMethodConfiguration;
import com.microsoft.graph.models.SmsAuthenticationMethodConfiguration;
import com.microsoft.graph.models.SoftwareOathAuthenticationMethodConfiguration;
import com.microsoft.graph.models.TemporaryAccessPassAuthenticationMethodConfiguration;
import com.microsoft.graph.models.VoiceAuthenticationMethodConfiguration;
import com.microsoft.graph.models.X509CertificateAuthenticationMethodConfiguration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AuthenticationMethodConfiguration
extends Entity
implements Parsable {
    @Nonnull
    public static AuthenticationMethodConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.emailAuthenticationMethodConfiguration": {
                    return new EmailAuthenticationMethodConfiguration();
                }
                case "#microsoft.graph.fido2AuthenticationMethodConfiguration": {
                    return new Fido2AuthenticationMethodConfiguration();
                }
                case "#microsoft.graph.microsoftAuthenticatorAuthenticationMethodConfiguration": {
                    return new MicrosoftAuthenticatorAuthenticationMethodConfiguration();
                }
                case "#microsoft.graph.smsAuthenticationMethodConfiguration": {
                    return new SmsAuthenticationMethodConfiguration();
                }
                case "#microsoft.graph.softwareOathAuthenticationMethodConfiguration": {
                    return new SoftwareOathAuthenticationMethodConfiguration();
                }
                case "#microsoft.graph.temporaryAccessPassAuthenticationMethodConfiguration": {
                    return new TemporaryAccessPassAuthenticationMethodConfiguration();
                }
                case "#microsoft.graph.voiceAuthenticationMethodConfiguration": {
                    return new VoiceAuthenticationMethodConfiguration();
                }
                case "#microsoft.graph.x509CertificateAuthenticationMethodConfiguration": {
                    return new X509CertificateAuthenticationMethodConfiguration();
                }
            }
        }
        return new AuthenticationMethodConfiguration();
    }

    @Nullable
    public List<ExcludeTarget> getExcludeTargets() {
        return (List)this.backingStore.get("excludeTargets");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("excludeTargets", n -> this.setExcludeTargets(n.getCollectionOfObjectValues(ExcludeTarget::createFromDiscriminatorValue)));
        deserializerMap.put("state", n -> this.setState((AuthenticationMethodState)n.getEnumValue(AuthenticationMethodState::forValue)));
        return deserializerMap;
    }

    @Nullable
    public AuthenticationMethodState getState() {
        return (AuthenticationMethodState)((Object)this.backingStore.get("state"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("excludeTargets", this.getExcludeTargets());
        writer.writeEnumValue("state", (Enum)this.getState());
    }

    public void setExcludeTargets(@Nullable List<ExcludeTarget> value) {
        this.backingStore.set("excludeTargets", value);
    }

    public void setState(@Nullable AuthenticationMethodState value) {
        this.backingStore.set("state", (Object)value);
    }
}

