/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ActivityBasedTimeoutPolicy;
import com.microsoft.graph.models.ClaimsMappingPolicy;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.HomeRealmDiscoveryPolicy;
import com.microsoft.graph.models.PolicyBase;
import com.microsoft.graph.models.TokenIssuancePolicy;
import com.microsoft.graph.models.TokenLifetimePolicy;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class StsPolicy
extends PolicyBase
implements Parsable {
    public StsPolicy() {
        this.setOdataType("#microsoft.graph.stsPolicy");
    }

    @Nonnull
    public static StsPolicy createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.activityBasedTimeoutPolicy": {
                    return new ActivityBasedTimeoutPolicy();
                }
                case "#microsoft.graph.claimsMappingPolicy": {
                    return new ClaimsMappingPolicy();
                }
                case "#microsoft.graph.homeRealmDiscoveryPolicy": {
                    return new HomeRealmDiscoveryPolicy();
                }
                case "#microsoft.graph.tokenIssuancePolicy": {
                    return new TokenIssuancePolicy();
                }
                case "#microsoft.graph.tokenLifetimePolicy": {
                    return new TokenLifetimePolicy();
                }
            }
        }
        return new StsPolicy();
    }

    @Nullable
    public List<DirectoryObject> getAppliesTo() {
        return (List)this.backingStore.get("appliesTo");
    }

    @Nullable
    public List<String> getDefinition() {
        return (List)this.backingStore.get("definition");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("appliesTo", n -> this.setAppliesTo(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("definition", n -> this.setDefinition(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("isOrganizationDefault", n -> this.setIsOrganizationDefault(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsOrganizationDefault() {
        return (Boolean)this.backingStore.get("isOrganizationDefault");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("appliesTo", this.getAppliesTo());
        writer.writeCollectionOfPrimitiveValues("definition", this.getDefinition());
        writer.writeBooleanValue("isOrganizationDefault", this.getIsOrganizationDefault());
    }

    public void setAppliesTo(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("appliesTo", value);
    }

    public void setDefinition(@Nullable List<String> value) {
        this.backingStore.set("definition", value);
    }

    public void setIsOrganizationDefault(@Nullable Boolean value) {
        this.backingStore.set("isOrganizationDefault", (Object)value);
    }
}

