/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ProtectionPolicyBase;
import com.microsoft.graph.models.SiteProtectionRule;
import com.microsoft.graph.models.SiteProtectionUnit;
import com.microsoft.graph.models.SiteProtectionUnitsBulkAdditionJob;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SharePointProtectionPolicy
extends ProtectionPolicyBase
implements Parsable {
    public SharePointProtectionPolicy() {
        this.setOdataType("#microsoft.graph.sharePointProtectionPolicy");
    }

    @Nonnull
    public static SharePointProtectionPolicy createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SharePointProtectionPolicy();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("siteInclusionRules", n -> this.setSiteInclusionRules(n.getCollectionOfObjectValues(SiteProtectionRule::createFromDiscriminatorValue)));
        deserializerMap.put("siteProtectionUnits", n -> this.setSiteProtectionUnits(n.getCollectionOfObjectValues(SiteProtectionUnit::createFromDiscriminatorValue)));
        deserializerMap.put("siteProtectionUnitsBulkAdditionJobs", n -> this.setSiteProtectionUnitsBulkAdditionJobs(n.getCollectionOfObjectValues(SiteProtectionUnitsBulkAdditionJob::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<SiteProtectionRule> getSiteInclusionRules() {
        return (List)this.backingStore.get("siteInclusionRules");
    }

    @Nullable
    public List<SiteProtectionUnit> getSiteProtectionUnits() {
        return (List)this.backingStore.get("siteProtectionUnits");
    }

    @Nullable
    public List<SiteProtectionUnitsBulkAdditionJob> getSiteProtectionUnitsBulkAdditionJobs() {
        return (List)this.backingStore.get("siteProtectionUnitsBulkAdditionJobs");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("siteInclusionRules", this.getSiteInclusionRules());
        writer.writeCollectionOfObjectValues("siteProtectionUnits", this.getSiteProtectionUnits());
        writer.writeCollectionOfObjectValues("siteProtectionUnitsBulkAdditionJobs", this.getSiteProtectionUnitsBulkAdditionJobs());
    }

    public void setSiteInclusionRules(@Nullable List<SiteProtectionRule> value) {
        this.backingStore.set("siteInclusionRules", value);
    }

    public void setSiteProtectionUnits(@Nullable List<SiteProtectionUnit> value) {
        this.backingStore.set("siteProtectionUnits", value);
    }

    public void setSiteProtectionUnitsBulkAdditionJobs(@Nullable List<SiteProtectionUnitsBulkAdditionJob> value) {
        this.backingStore.set("siteProtectionUnitsBulkAdditionJobs", value);
    }
}

