/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DayOfWeek;
import com.microsoft.graph.models.RecurrencePatternType;
import com.microsoft.graph.models.WeekIndex;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RecurrencePattern
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public RecurrencePattern() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static RecurrencePattern createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new RecurrencePattern();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Integer getDayOfMonth() {
        return (Integer)this.backingStore.get("dayOfMonth");
    }

    @Nullable
    public List<DayOfWeek> getDaysOfWeek() {
        return (List)this.backingStore.get("daysOfWeek");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("dayOfMonth", n -> this.setDayOfMonth(n.getIntegerValue()));
        deserializerMap.put("daysOfWeek", n -> this.setDaysOfWeek(n.getCollectionOfEnumValues(DayOfWeek::forValue)));
        deserializerMap.put("firstDayOfWeek", n -> this.setFirstDayOfWeek((DayOfWeek)n.getEnumValue(DayOfWeek::forValue)));
        deserializerMap.put("index", n -> this.setIndex((WeekIndex)n.getEnumValue(WeekIndex::forValue)));
        deserializerMap.put("interval", n -> this.setInterval(n.getIntegerValue()));
        deserializerMap.put("month", n -> this.setMonth(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("type", n -> this.setType((RecurrencePatternType)n.getEnumValue(RecurrencePatternType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public DayOfWeek getFirstDayOfWeek() {
        return (DayOfWeek)((Object)this.backingStore.get("firstDayOfWeek"));
    }

    @Nullable
    public WeekIndex getIndex() {
        return (WeekIndex)((Object)this.backingStore.get("index"));
    }

    @Nullable
    public Integer getInterval() {
        return (Integer)this.backingStore.get("interval");
    }

    @Nullable
    public Integer getMonth() {
        return (Integer)this.backingStore.get("month");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public RecurrencePatternType getType() {
        return (RecurrencePatternType)((Object)this.backingStore.get("type"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeIntegerValue("dayOfMonth", this.getDayOfMonth());
        writer.writeCollectionOfEnumValues("daysOfWeek", this.getDaysOfWeek());
        writer.writeEnumValue("firstDayOfWeek", (Enum)this.getFirstDayOfWeek());
        writer.writeEnumValue("index", (Enum)this.getIndex());
        writer.writeIntegerValue("interval", this.getInterval());
        writer.writeIntegerValue("month", this.getMonth());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("type", (Enum)this.getType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDayOfMonth(@Nullable Integer value) {
        this.backingStore.set("dayOfMonth", (Object)value);
    }

    public void setDaysOfWeek(@Nullable List<DayOfWeek> value) {
        this.backingStore.set("daysOfWeek", value);
    }

    public void setFirstDayOfWeek(@Nullable DayOfWeek value) {
        this.backingStore.set("firstDayOfWeek", (Object)value);
    }

    public void setIndex(@Nullable WeekIndex value) {
        this.backingStore.set("index", (Object)value);
    }

    public void setInterval(@Nullable Integer value) {
        this.backingStore.set("interval", (Object)value);
    }

    public void setMonth(@Nullable Integer value) {
        this.backingStore.set("month", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setType(@Nullable RecurrencePatternType value) {
        this.backingStore.set("type", (Object)value);
    }
}

