/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.OnlineMeetingRole;
import com.microsoft.graph.models.VirtualEventPresenterInfo;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MeetingParticipantInfo
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public MeetingParticipantInfo() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static MeetingParticipantInfo createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.virtualEventPresenterInfo": {
                    return new VirtualEventPresenterInfo();
                }
            }
        }
        return new MeetingParticipantInfo();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("identity", n -> this.setIdentity((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("role", n -> this.setRole((OnlineMeetingRole)n.getEnumValue(OnlineMeetingRole::forValue)));
        deserializerMap.put("upn", n -> this.setUpn(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getIdentity() {
        return (IdentitySet)this.backingStore.get("identity");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public OnlineMeetingRole getRole() {
        return (OnlineMeetingRole)((Object)this.backingStore.get("role"));
    }

    @Nullable
    public String getUpn() {
        return (String)this.backingStore.get("upn");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("identity", (Parsable)this.getIdentity(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("role", (Enum)this.getRole());
        writer.writeStringValue("upn", this.getUpn());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setIdentity(@Nullable IdentitySet value) {
        this.backingStore.set("identity", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRole(@Nullable OnlineMeetingRole value) {
        this.backingStore.set("role", (Object)value);
    }

    public void setUpn(@Nullable String value) {
        this.backingStore.set("upn", (Object)value);
    }
}

