/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.MembershipOutlierInsight;
import com.microsoft.graph.models.UserSignInInsight;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class GovernanceInsight
extends Entity
implements Parsable {
    @Nonnull
    public static GovernanceInsight createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.membershipOutlierInsight": {
                    return new MembershipOutlierInsight();
                }
                case "#microsoft.graph.userSignInInsight": {
                    return new UserSignInInsight();
                }
            }
        }
        return new GovernanceInsight();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("insightCreatedDateTime", n -> this.setInsightCreatedDateTime(n.getOffsetDateTimeValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getInsightCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("insightCreatedDateTime");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("insightCreatedDateTime", this.getInsightCreatedDateTime());
    }

    public void setInsightCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("insightCreatedDateTime", (Object)value);
    }
}

