/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.security.DeploymentStatus;
import com.microsoft.graph.models.security.HealthIssue;
import com.microsoft.graph.models.security.SensorHealthStatus;
import com.microsoft.graph.models.security.SensorSettings;
import com.microsoft.graph.models.security.SensorType;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Sensor
extends Entity
implements Parsable {
    @Nonnull
    public static Sensor createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Sensor();
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public DeploymentStatus getDeploymentStatus() {
        return (DeploymentStatus)((Object)this.backingStore.get("deploymentStatus"));
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public String getDomainName() {
        return (String)this.backingStore.get("domainName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("deploymentStatus", n -> this.setDeploymentStatus((DeploymentStatus)n.getEnumValue(DeploymentStatus::forValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("domainName", n -> this.setDomainName(n.getStringValue()));
        deserializerMap.put("healthIssues", n -> this.setHealthIssues(n.getCollectionOfObjectValues(HealthIssue::createFromDiscriminatorValue)));
        deserializerMap.put("healthStatus", n -> this.setHealthStatus((SensorHealthStatus)n.getEnumValue(SensorHealthStatus::forValue)));
        deserializerMap.put("openHealthIssuesCount", n -> this.setOpenHealthIssuesCount(n.getLongValue()));
        deserializerMap.put("sensorType", n -> this.setSensorType((SensorType)n.getEnumValue(SensorType::forValue)));
        deserializerMap.put("settings", n -> this.setSettings((SensorSettings)n.getObjectValue(SensorSettings::createFromDiscriminatorValue)));
        deserializerMap.put("version", n -> this.setVersion(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public List<HealthIssue> getHealthIssues() {
        return (List)this.backingStore.get("healthIssues");
    }

    @Nullable
    public SensorHealthStatus getHealthStatus() {
        return (SensorHealthStatus)((Object)this.backingStore.get("healthStatus"));
    }

    @Nullable
    public Long getOpenHealthIssuesCount() {
        return (Long)this.backingStore.get("openHealthIssuesCount");
    }

    @Nullable
    public SensorType getSensorType() {
        return (SensorType)((Object)this.backingStore.get("sensorType"));
    }

    @Nullable
    public SensorSettings getSettings() {
        return (SensorSettings)this.backingStore.get("settings");
    }

    @Nullable
    public String getVersion() {
        return (String)this.backingStore.get("version");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeEnumValue("deploymentStatus", (Enum)this.getDeploymentStatus());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("domainName", this.getDomainName());
        writer.writeCollectionOfObjectValues("healthIssues", this.getHealthIssues());
        writer.writeEnumValue("healthStatus", (Enum)this.getHealthStatus());
        writer.writeLongValue("openHealthIssuesCount", this.getOpenHealthIssuesCount());
        writer.writeEnumValue("sensorType", (Enum)this.getSensorType());
        writer.writeObjectValue("settings", (Parsable)this.getSettings(), new Parsable[0]);
        writer.writeStringValue("version", this.getVersion());
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDeploymentStatus(@Nullable DeploymentStatus value) {
        this.backingStore.set("deploymentStatus", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setDomainName(@Nullable String value) {
        this.backingStore.set("domainName", (Object)value);
    }

    public void setHealthIssues(@Nullable List<HealthIssue> value) {
        this.backingStore.set("healthIssues", value);
    }

    public void setHealthStatus(@Nullable SensorHealthStatus value) {
        this.backingStore.set("healthStatus", (Object)value);
    }

    public void setOpenHealthIssuesCount(@Nullable Long value) {
        this.backingStore.set("openHealthIssuesCount", (Object)value);
    }

    public void setSensorType(@Nullable SensorType value) {
        this.backingStore.set("sensorType", (Object)value);
    }

    public void setSettings(@Nullable SensorSettings value) {
        this.backingStore.set("settings", (Object)value);
    }

    public void setVersion(@Nullable String value) {
        this.backingStore.set("version", (Object)value);
    }
}

