/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DriveProtectionRule;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.MailboxProtectionRule;
import com.microsoft.graph.models.ProtectionRuleStatus;
import com.microsoft.graph.models.PublicError;
import com.microsoft.graph.models.SiteProtectionRule;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ProtectionRuleBase
extends Entity
implements Parsable {
    @Nonnull
    public static ProtectionRuleBase createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.driveProtectionRule": {
                    return new DriveProtectionRule();
                }
                case "#microsoft.graph.mailboxProtectionRule": {
                    return new MailboxProtectionRule();
                }
                case "#microsoft.graph.siteProtectionRule": {
                    return new SiteProtectionRule();
                }
            }
        }
        return new ProtectionRuleBase();
    }

    @Nullable
    public IdentitySet getCreatedBy() {
        return (IdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public PublicError getError() {
        return (PublicError)this.backingStore.get("error");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdBy", n -> this.setCreatedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("error", n -> this.setError((PublicError)n.getObjectValue(PublicError::createFromDiscriminatorValue)));
        deserializerMap.put("isAutoApplyEnabled", n -> this.setIsAutoApplyEnabled(n.getBooleanValue()));
        deserializerMap.put("lastModifiedBy", n -> this.setLastModifiedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("status", n -> this.setStatus((ProtectionRuleStatus)n.getEnumValue(ProtectionRuleStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsAutoApplyEnabled() {
        return (Boolean)this.backingStore.get("isAutoApplyEnabled");
    }

    @Nullable
    public IdentitySet getLastModifiedBy() {
        return (IdentitySet)this.backingStore.get("lastModifiedBy");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public ProtectionRuleStatus getStatus() {
        return (ProtectionRuleStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeObjectValue("error", (Parsable)this.getError(), new Parsable[0]);
        writer.writeBooleanValue("isAutoApplyEnabled", this.getIsAutoApplyEnabled());
        writer.writeObjectValue("lastModifiedBy", (Parsable)this.getLastModifiedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setCreatedBy(@Nullable IdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setError(@Nullable PublicError value) {
        this.backingStore.set("error", (Object)value);
    }

    public void setIsAutoApplyEnabled(@Nullable Boolean value) {
        this.backingStore.set("isAutoApplyEnabled", (Object)value);
    }

    public void setLastModifiedBy(@Nullable IdentitySet value) {
        this.backingStore.set("lastModifiedBy", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setStatus(@Nullable ProtectionRuleStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

