/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AdministrativeUnit;
import com.microsoft.graph.models.AttributeSet;
import com.microsoft.graph.models.CompanySubscription;
import com.microsoft.graph.models.CustomSecurityAttributeDefinition;
import com.microsoft.graph.models.DeviceLocalCredentialInfo;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentityProviderBase;
import com.microsoft.graph.models.OnPremisesDirectorySynchronization;
import com.microsoft.graph.models.PublicKeyInfrastructureRoot;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Directory
extends Entity
implements Parsable {
    @Nonnull
    public static Directory createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Directory();
    }

    @Nullable
    public List<AdministrativeUnit> getAdministrativeUnits() {
        return (List)this.backingStore.get("administrativeUnits");
    }

    @Nullable
    public List<AttributeSet> getAttributeSets() {
        return (List)this.backingStore.get("attributeSets");
    }

    @Nullable
    public List<CustomSecurityAttributeDefinition> getCustomSecurityAttributeDefinitions() {
        return (List)this.backingStore.get("customSecurityAttributeDefinitions");
    }

    @Nullable
    public List<DirectoryObject> getDeletedItems() {
        return (List)this.backingStore.get("deletedItems");
    }

    @Nullable
    public List<DeviceLocalCredentialInfo> getDeviceLocalCredentials() {
        return (List)this.backingStore.get("deviceLocalCredentials");
    }

    @Nullable
    public List<IdentityProviderBase> getFederationConfigurations() {
        return (List)this.backingStore.get("federationConfigurations");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("administrativeUnits", n -> this.setAdministrativeUnits(n.getCollectionOfObjectValues(AdministrativeUnit::createFromDiscriminatorValue)));
        deserializerMap.put("attributeSets", n -> this.setAttributeSets(n.getCollectionOfObjectValues(AttributeSet::createFromDiscriminatorValue)));
        deserializerMap.put("customSecurityAttributeDefinitions", n -> this.setCustomSecurityAttributeDefinitions(n.getCollectionOfObjectValues(CustomSecurityAttributeDefinition::createFromDiscriminatorValue)));
        deserializerMap.put("deletedItems", n -> this.setDeletedItems(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("deviceLocalCredentials", n -> this.setDeviceLocalCredentials(n.getCollectionOfObjectValues(DeviceLocalCredentialInfo::createFromDiscriminatorValue)));
        deserializerMap.put("federationConfigurations", n -> this.setFederationConfigurations(n.getCollectionOfObjectValues(IdentityProviderBase::createFromDiscriminatorValue)));
        deserializerMap.put("onPremisesSynchronization", n -> this.setOnPremisesSynchronization(n.getCollectionOfObjectValues(OnPremisesDirectorySynchronization::createFromDiscriminatorValue)));
        deserializerMap.put("publicKeyInfrastructure", n -> this.setPublicKeyInfrastructure((PublicKeyInfrastructureRoot)n.getObjectValue(PublicKeyInfrastructureRoot::createFromDiscriminatorValue)));
        deserializerMap.put("subscriptions", n -> this.setSubscriptions(n.getCollectionOfObjectValues(CompanySubscription::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<OnPremisesDirectorySynchronization> getOnPremisesSynchronization() {
        return (List)this.backingStore.get("onPremisesSynchronization");
    }

    @Nullable
    public PublicKeyInfrastructureRoot getPublicKeyInfrastructure() {
        return (PublicKeyInfrastructureRoot)this.backingStore.get("publicKeyInfrastructure");
    }

    @Nullable
    public List<CompanySubscription> getSubscriptions() {
        return (List)this.backingStore.get("subscriptions");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("administrativeUnits", this.getAdministrativeUnits());
        writer.writeCollectionOfObjectValues("attributeSets", this.getAttributeSets());
        writer.writeCollectionOfObjectValues("customSecurityAttributeDefinitions", this.getCustomSecurityAttributeDefinitions());
        writer.writeCollectionOfObjectValues("deletedItems", this.getDeletedItems());
        writer.writeCollectionOfObjectValues("deviceLocalCredentials", this.getDeviceLocalCredentials());
        writer.writeCollectionOfObjectValues("federationConfigurations", this.getFederationConfigurations());
        writer.writeCollectionOfObjectValues("onPremisesSynchronization", this.getOnPremisesSynchronization());
        writer.writeObjectValue("publicKeyInfrastructure", (Parsable)this.getPublicKeyInfrastructure(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("subscriptions", this.getSubscriptions());
    }

    public void setAdministrativeUnits(@Nullable List<AdministrativeUnit> value) {
        this.backingStore.set("administrativeUnits", value);
    }

    public void setAttributeSets(@Nullable List<AttributeSet> value) {
        this.backingStore.set("attributeSets", value);
    }

    public void setCustomSecurityAttributeDefinitions(@Nullable List<CustomSecurityAttributeDefinition> value) {
        this.backingStore.set("customSecurityAttributeDefinitions", value);
    }

    public void setDeletedItems(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("deletedItems", value);
    }

    public void setDeviceLocalCredentials(@Nullable List<DeviceLocalCredentialInfo> value) {
        this.backingStore.set("deviceLocalCredentials", value);
    }

    public void setFederationConfigurations(@Nullable List<IdentityProviderBase> value) {
        this.backingStore.set("federationConfigurations", value);
    }

    public void setOnPremisesSynchronization(@Nullable List<OnPremisesDirectorySynchronization> value) {
        this.backingStore.set("onPremisesSynchronization", value);
    }

    public void setPublicKeyInfrastructure(@Nullable PublicKeyInfrastructureRoot value) {
        this.backingStore.set("publicKeyInfrastructure", (Object)value);
    }

    public void setSubscriptions(@Nullable List<CompanySubscription> value) {
        this.backingStore.set("subscriptions", value);
    }
}

