/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.WindowsMalwareCategory;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WindowsMalwareCategoryCount
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public WindowsMalwareCategoryCount() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static WindowsMalwareCategoryCount createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WindowsMalwareCategoryCount();
    }

    @Nullable
    public Integer getActiveMalwareDetectionCount() {
        return (Integer)this.backingStore.get("activeMalwareDetectionCount");
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public WindowsMalwareCategory getCategory() {
        return (WindowsMalwareCategory)((Object)this.backingStore.get("category"));
    }

    @Nullable
    public Integer getDeviceCount() {
        return (Integer)this.backingStore.get("deviceCount");
    }

    @Nullable
    public Integer getDistinctActiveMalwareCount() {
        return (Integer)this.backingStore.get("distinctActiveMalwareCount");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("activeMalwareDetectionCount", n -> this.setActiveMalwareDetectionCount(n.getIntegerValue()));
        deserializerMap.put("category", n -> this.setCategory((WindowsMalwareCategory)n.getEnumValue(WindowsMalwareCategory::forValue)));
        deserializerMap.put("deviceCount", n -> this.setDeviceCount(n.getIntegerValue()));
        deserializerMap.put("distinctActiveMalwareCount", n -> this.setDistinctActiveMalwareCount(n.getIntegerValue()));
        deserializerMap.put("lastUpdateDateTime", n -> this.setLastUpdateDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastUpdateDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastUpdateDateTime");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeIntegerValue("activeMalwareDetectionCount", this.getActiveMalwareDetectionCount());
        writer.writeEnumValue("category", (Enum)this.getCategory());
        writer.writeIntegerValue("deviceCount", this.getDeviceCount());
        writer.writeIntegerValue("distinctActiveMalwareCount", this.getDistinctActiveMalwareCount());
        writer.writeOffsetDateTimeValue("lastUpdateDateTime", this.getLastUpdateDateTime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setActiveMalwareDetectionCount(@Nullable Integer value) {
        this.backingStore.set("activeMalwareDetectionCount", (Object)value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCategory(@Nullable WindowsMalwareCategory value) {
        this.backingStore.set("category", (Object)value);
    }

    public void setDeviceCount(@Nullable Integer value) {
        this.backingStore.set("deviceCount", (Object)value);
    }

    public void setDistinctActiveMalwareCount(@Nullable Integer value) {
        this.backingStore.set("distinctActiveMalwareCount", (Object)value);
    }

    public void setLastUpdateDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastUpdateDateTime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

