/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.EducationItemBody;
import com.microsoft.graph.models.RubricCriterion;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RubricQuality
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public RubricQuality() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static RubricQuality createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new RubricQuality();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<RubricCriterion> getCriteria() {
        return (List)this.backingStore.get("criteria");
    }

    @Nullable
    public EducationItemBody getDescription() {
        return (EducationItemBody)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("criteria", n -> this.setCriteria(n.getCollectionOfObjectValues(RubricCriterion::createFromDiscriminatorValue)));
        deserializerMap.put("description", n -> this.setDescription((EducationItemBody)n.getObjectValue(EducationItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("qualityId", n -> this.setQualityId(n.getStringValue()));
        deserializerMap.put("weight", n -> this.setWeight(n.getFloatValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getQualityId() {
        return (String)this.backingStore.get("qualityId");
    }

    @Nullable
    public Float getWeight() {
        return (Float)this.backingStore.get("weight");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("criteria", this.getCriteria());
        writer.writeObjectValue("description", (Parsable)this.getDescription(), new Parsable[0]);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("qualityId", this.getQualityId());
        writer.writeFloatValue("weight", this.getWeight());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCriteria(@Nullable List<RubricCriterion> value) {
        this.backingStore.set("criteria", value);
    }

    public void setDescription(@Nullable EducationItemBody value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setQualityId(@Nullable String value) {
        this.backingStore.set("qualityId", (Object)value);
    }

    public void setWeight(@Nullable Float value) {
        this.backingStore.set("weight", (Object)value);
    }
}

