/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.PrintColorMode;
import com.microsoft.graph.models.PrintDuplexMode;
import com.microsoft.graph.models.PrintFinishing;
import com.microsoft.graph.models.PrintMultipageLayout;
import com.microsoft.graph.models.PrintOrientation;
import com.microsoft.graph.models.PrintQuality;
import com.microsoft.graph.models.PrintScaling;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PrinterDefaults
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public PrinterDefaults() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static PrinterDefaults createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new PrinterDefaults();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public PrintColorMode getColorMode() {
        return (PrintColorMode)((Object)this.backingStore.get("colorMode"));
    }

    @Nullable
    public String getContentType() {
        return (String)this.backingStore.get("contentType");
    }

    @Nullable
    public Integer getCopiesPerJob() {
        return (Integer)this.backingStore.get("copiesPerJob");
    }

    @Nullable
    public Integer getDpi() {
        return (Integer)this.backingStore.get("dpi");
    }

    @Nullable
    public PrintDuplexMode getDuplexMode() {
        return (PrintDuplexMode)((Object)this.backingStore.get("duplexMode"));
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(18);
        deserializerMap.put("colorMode", n -> this.setColorMode((PrintColorMode)n.getEnumValue(PrintColorMode::forValue)));
        deserializerMap.put("contentType", n -> this.setContentType(n.getStringValue()));
        deserializerMap.put("copiesPerJob", n -> this.setCopiesPerJob(n.getIntegerValue()));
        deserializerMap.put("dpi", n -> this.setDpi(n.getIntegerValue()));
        deserializerMap.put("duplexMode", n -> this.setDuplexMode((PrintDuplexMode)n.getEnumValue(PrintDuplexMode::forValue)));
        deserializerMap.put("finishings", n -> this.setFinishings(n.getCollectionOfEnumValues(PrintFinishing::forValue)));
        deserializerMap.put("fitPdfToPage", n -> this.setFitPdfToPage(n.getBooleanValue()));
        deserializerMap.put("inputBin", n -> this.setInputBin(n.getStringValue()));
        deserializerMap.put("mediaColor", n -> this.setMediaColor(n.getStringValue()));
        deserializerMap.put("mediaSize", n -> this.setMediaSize(n.getStringValue()));
        deserializerMap.put("mediaType", n -> this.setMediaType(n.getStringValue()));
        deserializerMap.put("multipageLayout", n -> this.setMultipageLayout((PrintMultipageLayout)n.getEnumValue(PrintMultipageLayout::forValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("orientation", n -> this.setOrientation((PrintOrientation)n.getEnumValue(PrintOrientation::forValue)));
        deserializerMap.put("outputBin", n -> this.setOutputBin(n.getStringValue()));
        deserializerMap.put("pagesPerSheet", n -> this.setPagesPerSheet(n.getIntegerValue()));
        deserializerMap.put("quality", n -> this.setQuality((PrintQuality)n.getEnumValue(PrintQuality::forValue)));
        deserializerMap.put("scaling", n -> this.setScaling((PrintScaling)n.getEnumValue(PrintScaling::forValue)));
        return deserializerMap;
    }

    @Nullable
    public List<PrintFinishing> getFinishings() {
        return (List)this.backingStore.get("finishings");
    }

    @Nullable
    public Boolean getFitPdfToPage() {
        return (Boolean)this.backingStore.get("fitPdfToPage");
    }

    @Nullable
    public String getInputBin() {
        return (String)this.backingStore.get("inputBin");
    }

    @Nullable
    public String getMediaColor() {
        return (String)this.backingStore.get("mediaColor");
    }

    @Nullable
    public String getMediaSize() {
        return (String)this.backingStore.get("mediaSize");
    }

    @Nullable
    public String getMediaType() {
        return (String)this.backingStore.get("mediaType");
    }

    @Nullable
    public PrintMultipageLayout getMultipageLayout() {
        return (PrintMultipageLayout)((Object)this.backingStore.get("multipageLayout"));
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public PrintOrientation getOrientation() {
        return (PrintOrientation)((Object)this.backingStore.get("orientation"));
    }

    @Nullable
    public String getOutputBin() {
        return (String)this.backingStore.get("outputBin");
    }

    @Nullable
    public Integer getPagesPerSheet() {
        return (Integer)this.backingStore.get("pagesPerSheet");
    }

    @Nullable
    public PrintQuality getQuality() {
        return (PrintQuality)((Object)this.backingStore.get("quality"));
    }

    @Nullable
    public PrintScaling getScaling() {
        return (PrintScaling)((Object)this.backingStore.get("scaling"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumValue("colorMode", (Enum)this.getColorMode());
        writer.writeStringValue("contentType", this.getContentType());
        writer.writeIntegerValue("copiesPerJob", this.getCopiesPerJob());
        writer.writeIntegerValue("dpi", this.getDpi());
        writer.writeEnumValue("duplexMode", (Enum)this.getDuplexMode());
        writer.writeCollectionOfEnumValues("finishings", this.getFinishings());
        writer.writeBooleanValue("fitPdfToPage", this.getFitPdfToPage());
        writer.writeStringValue("inputBin", this.getInputBin());
        writer.writeStringValue("mediaColor", this.getMediaColor());
        writer.writeStringValue("mediaSize", this.getMediaSize());
        writer.writeStringValue("mediaType", this.getMediaType());
        writer.writeEnumValue("multipageLayout", (Enum)this.getMultipageLayout());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("orientation", (Enum)this.getOrientation());
        writer.writeStringValue("outputBin", this.getOutputBin());
        writer.writeIntegerValue("pagesPerSheet", this.getPagesPerSheet());
        writer.writeEnumValue("quality", (Enum)this.getQuality());
        writer.writeEnumValue("scaling", (Enum)this.getScaling());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setColorMode(@Nullable PrintColorMode value) {
        this.backingStore.set("colorMode", (Object)value);
    }

    public void setContentType(@Nullable String value) {
        this.backingStore.set("contentType", (Object)value);
    }

    public void setCopiesPerJob(@Nullable Integer value) {
        this.backingStore.set("copiesPerJob", (Object)value);
    }

    public void setDpi(@Nullable Integer value) {
        this.backingStore.set("dpi", (Object)value);
    }

    public void setDuplexMode(@Nullable PrintDuplexMode value) {
        this.backingStore.set("duplexMode", (Object)value);
    }

    public void setFinishings(@Nullable List<PrintFinishing> value) {
        this.backingStore.set("finishings", value);
    }

    public void setFitPdfToPage(@Nullable Boolean value) {
        this.backingStore.set("fitPdfToPage", (Object)value);
    }

    public void setInputBin(@Nullable String value) {
        this.backingStore.set("inputBin", (Object)value);
    }

    public void setMediaColor(@Nullable String value) {
        this.backingStore.set("mediaColor", (Object)value);
    }

    public void setMediaSize(@Nullable String value) {
        this.backingStore.set("mediaSize", (Object)value);
    }

    public void setMediaType(@Nullable String value) {
        this.backingStore.set("mediaType", (Object)value);
    }

    public void setMultipageLayout(@Nullable PrintMultipageLayout value) {
        this.backingStore.set("multipageLayout", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOrientation(@Nullable PrintOrientation value) {
        this.backingStore.set("orientation", (Object)value);
    }

    public void setOutputBin(@Nullable String value) {
        this.backingStore.set("outputBin", (Object)value);
    }

    public void setPagesPerSheet(@Nullable Integer value) {
        this.backingStore.set("pagesPerSheet", (Object)value);
    }

    public void setQuality(@Nullable PrintQuality value) {
        this.backingStore.set("quality", (Object)value);
    }

    public void setScaling(@Nullable PrintScaling value) {
        this.backingStore.set("scaling", (Object)value);
    }
}

