/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.CrossTenantAccessPolicyConfigurationDefault;
import com.microsoft.graph.models.CrossTenantAccessPolicyConfigurationPartner;
import com.microsoft.graph.models.PolicyBase;
import com.microsoft.graph.models.PolicyTemplate;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class CrossTenantAccessPolicy
extends PolicyBase
implements Parsable {
    public CrossTenantAccessPolicy() {
        this.setOdataType("#microsoft.graph.crossTenantAccessPolicy");
    }

    @Nonnull
    public static CrossTenantAccessPolicy createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new CrossTenantAccessPolicy();
    }

    @Nullable
    public List<String> getAllowedCloudEndpoints() {
        return (List)this.backingStore.get("allowedCloudEndpoints");
    }

    @Nullable
    public CrossTenantAccessPolicyConfigurationDefault getDefault() {
        return (CrossTenantAccessPolicyConfigurationDefault)this.backingStore.get("default");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("allowedCloudEndpoints", n -> this.setAllowedCloudEndpoints(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("default", n -> this.setDefault((CrossTenantAccessPolicyConfigurationDefault)n.getObjectValue(CrossTenantAccessPolicyConfigurationDefault::createFromDiscriminatorValue)));
        deserializerMap.put("partners", n -> this.setPartners(n.getCollectionOfObjectValues(CrossTenantAccessPolicyConfigurationPartner::createFromDiscriminatorValue)));
        deserializerMap.put("templates", n -> this.setTemplates((PolicyTemplate)n.getObjectValue(PolicyTemplate::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<CrossTenantAccessPolicyConfigurationPartner> getPartners() {
        return (List)this.backingStore.get("partners");
    }

    @Nullable
    public PolicyTemplate getTemplates() {
        return (PolicyTemplate)this.backingStore.get("templates");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfPrimitiveValues("allowedCloudEndpoints", this.getAllowedCloudEndpoints());
        writer.writeObjectValue("default", (Parsable)this.getDefault(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("partners", this.getPartners());
        writer.writeObjectValue("templates", (Parsable)this.getTemplates(), new Parsable[0]);
    }

    public void setAllowedCloudEndpoints(@Nullable List<String> value) {
        this.backingStore.set("allowedCloudEndpoints", value);
    }

    public void setDefault(@Nullable CrossTenantAccessPolicyConfigurationDefault value) {
        this.backingStore.set("default", (Object)value);
    }

    public void setPartners(@Nullable List<CrossTenantAccessPolicyConfigurationPartner> value) {
        this.backingStore.set("partners", value);
    }

    public void setTemplates(@Nullable PolicyTemplate value) {
        this.backingStore.set("templates", (Object)value);
    }
}

